/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.dialog.gang;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.dialog.generic.GenericConfirmDialog;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.excellentgangs.registry.GangLevels;
import su.nightexpress.excellentgangs.util.GangUtils;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class GangUpgradeDialog
extends GenericConfirmDialog<Gang> {
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Dialog.Gang.Upgrade.Body").dialogElement(400, new String[]{"You're about to upgrade the gang level to " + TagWrappers.SOFT_YELLOW.wrap("%level_name%") + ".", "", TagWrappers.RED.wrap("Level Requirements: ") + "%requirements%", "", TagWrappers.YELLOW.wrap("Do you want to continue?")});

    @Override
    @NotNull
    protected List<WrappedDialogBody> body(@NotNull Gang gang) {
        GangLevel level = gang.getLevel();
        GangLevel nextLevel = GangLevels.getNext(level);
        if (nextLevel == null) {
            throw new IllegalStateException("No next level found");
        }
        return List.of(DialogBodies.plainMessage((DialogElementLocale)BODY.replace(str -> (String)nextLevel.replacePlaceholders().apply(str.replace("%requirements%", GangUtils.formatRequirements(nextLevel))))));
    }
}

