/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentgangs.GangsPlaceholders;
import su.nightexpress.excellentgangs.api.level.LevelFeature;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.gang.GangInvite;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.excellentgangs.gang.bank.GangBank;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.gang.vault.GangVault;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.message.LangMessage;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.placeholder.Replacer;

public class Gang {
    private final UUID id;
    private final GangBank bank;
    private final Map<UUID, GangMember> memberByIdMap;
    private final Map<UUID, GangInvite> inviteMap;
    private String idName;
    private String name;
    private UUID ownerId;
    private GangLevel level;
    private GangVault vault;
    private boolean friendlyFire;
    private String prefix;
    private boolean dirty;

    public Gang(@NotNull UUID id, @NotNull String idName, @NotNull String name, @NotNull UUID ownerId, @NotNull GangLevel level, @NotNull GangBank bank, boolean friendlyFire, @NotNull Map<UUID, GangMember> memberByIdMap) {
        this.id = id;
        this.idName = idName;
        this.name = name;
        this.ownerId = ownerId;
        this.level = level;
        this.bank = bank;
        this.memberByIdMap = memberByIdMap;
        this.inviteMap = new HashMap<UUID, GangInvite>();
        this.setFriendlyFire(friendlyFire);
        this.getMembers().forEach(member -> member.setGang(this));
        this.updatePrefix();
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return GangsPlaceholders.GANG.replacer((Object)this);
    }

    public void updatePrefix() {
        this.prefix = (String)this.replacePlaceholders().apply((String)Config.GANG_PREFIX_INTERNAL.get());
    }

    @NotNull
    private LangMessage message(@NotNull MessageLocale locale) {
        if (!((Boolean)Config.GANG_PREFIX_ENABLED.get()).booleanValue()) {
            return locale.message();
        }
        return locale.withPrefix(this.prefix);
    }

    public void rename(@NotNull String idName, @NotNull String name) {
        this.idName = idName;
        this.name = name;
        this.updatePrefix();
    }

    public void level(@NotNull GangLevel level) {
        this.level = level;
        this.updatePrefix();
    }

    public void sendInternalMessage(@NotNull MessageLocale locale) {
        this.sendInternalMessage(locale, null);
    }

    public void sendInternalMessage(@NotNull MessageLocale locale, @Nullable Consumer<Replacer> consumer) {
        this.sendMessage(locale, this.getOnlinePlayers(), consumer);
    }

    public void sendMessage(@NotNull MessageLocale locale, @NotNull CommandSender sender) {
        this.sendMessage(locale, sender, null);
    }

    public void sendMessage(@NotNull MessageLocale locale, @NotNull CommandSender sender, @Nullable Consumer<Replacer> consumer) {
        this.sendMessage(locale, List.of(sender), consumer);
    }

    public void sendMessage(@NotNull MessageLocale locale, @NotNull Collection<? extends CommandSender> senders, @Nullable Consumer<Replacer> consumer) {
        this.message(locale).send(senders, replacer -> {
            replacer.replace(this.replacePlaceholders());
            if (consumer != null) {
                consumer.accept((Replacer)replacer);
            }
        });
    }

    public void addInvite(@NotNull GangInvite invite) {
        this.inviteMap.put(invite.getPlayerId(), invite);
    }

    public boolean removeInvite(@NotNull GangInvite invite) {
        return this.removeInvite(invite.getPlayerId());
    }

    public boolean removeInvite(@NotNull UUID playerId) {
        return this.inviteMap.remove(playerId) != null;
    }

    public void removeExpiredInvites() {
        this.inviteMap.values().removeIf(GangInvite::isExpired);
    }

    @Nullable
    public GangInvite getInvite(@NotNull UUID playerId) {
        return this.inviteMap.get(playerId);
    }

    public void addMember(@NotNull GangMember member) {
        member.setGang(this);
        this.memberByIdMap.put(member.getPlayerId(), member);
    }

    public boolean removeMember(@NotNull GangMember member) {
        return this.removeMember(member.getPlayerId());
    }

    public boolean removeMember(@NotNull Player player) {
        return this.removeMember(player.getUniqueId());
    }

    public boolean removeMember(@NotNull UUID playerId) {
        GangMember member = this.memberByIdMap.remove(playerId);
        if (member == null) {
            return false;
        }
        member.setGang(null);
        return true;
    }

    @NotNull
    public Set<Player> getOnlinePlayers() {
        return this.getMembers().stream().map(GangMember::getPlayer).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @NotNull
    public Set<GangMember> getMembers() {
        return new HashSet<GangMember>(this.memberByIdMap.values());
    }

    @NotNull
    public Set<UUID> getMemberIds() {
        return new HashSet<UUID>(this.memberByIdMap.keySet());
    }

    @NotNull
    public Set<String> getMemberNames() {
        return this.memberByIdMap.values().stream().map(GangMember::getName).collect(Collectors.toSet());
    }

    @Nullable
    public GangMember getMember(@NotNull String playerName) {
        return this.memberByIdMap.values().stream().filter(member -> member.getName().equalsIgnoreCase(playerName)).findFirst().orElse(null);
    }

    @Nullable
    public GangMember getMember(@NotNull Player player) {
        return this.getMember(player.getUniqueId());
    }

    @NotNull
    public Optional<GangMember> member(@NotNull Player player) {
        return Optional.ofNullable(this.getMember(player));
    }

    @Nullable
    public GangMember getMember(@NotNull UUID id) {
        return this.memberByIdMap.get(id);
    }

    @NotNull
    public Optional<GangMember> member(@NotNull UUID id) {
        return Optional.ofNullable(this.getMember(id));
    }

    @NotNull
    public GangMember getOwnerMember() {
        return this.member(this.ownerId).orElseThrow();
    }

    public boolean hasInvite(@NotNull Player player) {
        return this.hasInvite(player.getUniqueId());
    }

    public boolean hasInvite(@NotNull UUID playerId) {
        this.removeExpiredInvites();
        return this.inviteMap.containsKey(playerId);
    }

    public boolean isMember(@NotNull Player player) {
        return this.isMember(player.getUniqueId());
    }

    public boolean isMember(@NotNull UUID id) {
        return this.memberByIdMap.containsKey(id);
    }

    public boolean isOwner(@NotNull Player player) {
        return this.isOwner(player.getUniqueId());
    }

    public boolean isOwner(@NotNull UUID playerId) {
        return this.ownerId.equals(playerId);
    }

    public boolean isPermitted(@NotNull Player player, @NotNull GangPermission permission) {
        return this.member(player).map(member -> member.isPermitted(permission)).orElse(false);
    }

    public int countMembers() {
        return this.memberByIdMap.size();
    }

    public int getMembersLimit() {
        return this.level.getMaxMembers();
    }

    public boolean isMaxMembers() {
        return this.countMembers() >= this.getMembersLimit();
    }

    public boolean isVaultUnlocked() {
        return this.level.hasFeature(LevelFeature.VAULT);
    }

    public int getVaultSize() {
        return this.level.getVaultSize();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean hasVault() {
        return this.vault != null;
    }

    @Nullable
    public Player getOwner() {
        return Players.getPlayer((UUID)this.ownerId);
    }

    @NotNull
    public String getOwnerName() {
        return this.getOwnerMember().getName();
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @NotNull
    public String getIdName() {
        return this.idName;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(@NotNull UUID ownerId) {
        this.ownerId = ownerId;
    }

    @NotNull
    public GangLevel getLevel() {
        return this.level;
    }

    @NotNull
    public GangBank getBank() {
        return this.bank;
    }

    @NotNull
    public GangVault getVault() {
        if (this.vault == null) {
            throw new IllegalStateException("Gang has no vault!");
        }
        return this.vault;
    }

    public void setVault(@Nullable GangVault vault) {
        this.vault = vault;
    }

    public boolean isFriendlyFire() {
        return this.friendlyFire;
    }

    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    @NotNull
    public Map<UUID, GangMember> getMemberByIdMap() {
        return this.memberByIdMap;
    }
}

