/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentgangs.GangsPlaceholders;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.api.level.LevelFeature;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.config.Lang;
import su.nightexpress.excellentgangs.dialog.GangDialogs;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangInvite;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.excellentgangs.gang.bank.GangBank;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.excellentgangs.gang.level.GangLevelLoader;
import su.nightexpress.excellentgangs.gang.listener.GenericGangListener;
import su.nightexpress.excellentgangs.gang.listener.PaperGangListener;
import su.nightexpress.excellentgangs.gang.listener.SpigotGangListener;
import su.nightexpress.excellentgangs.gang.menu.GangMenu;
import su.nightexpress.excellentgangs.gang.menu.LevelsMenu;
import su.nightexpress.excellentgangs.gang.menu.MemberInventoryMenu;
import su.nightexpress.excellentgangs.gang.menu.MemberMenu;
import su.nightexpress.excellentgangs.gang.menu.VaultMenu;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.gang.rank.GangRank;
import su.nightexpress.excellentgangs.gang.vault.GangVault;
import su.nightexpress.excellentgangs.registry.GangLevels;
import su.nightexpress.excellentgangs.registry.GangRanks;
import su.nightexpress.excellentgangs.requirement.LevelRequirementFactory;
import su.nightexpress.excellentgangs.util.GangDefaults;
import su.nightexpress.excellentgangs.util.GangUtils;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.util.Numbers;
import su.nightexpress.nightcore.util.Strings;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class GangManager
extends AbstractManager<GangsPlugin> {
    private final LevelRequirementFactory requirementFactory;
    private final Map<UUID, Gang> gangByIdMap;
    private final Map<String, Gang> gangByNameMap;
    private final Map<UUID, GangMember> gangByMemberMap;
    private GangMenu gangMenu;
    private MemberMenu memberMenu;
    private MemberInventoryMenu memberInventoryMenu;
    private VaultMenu vaultMenu;
    private LevelsMenu levelsMenu;
    private boolean loaded;

    public GangManager(@NotNull GangsPlugin plugin, @NotNull LevelRequirementFactory requirementFactory) {
        super((NightCorePlugin)plugin);
        this.requirementFactory = requirementFactory;
        this.gangByIdMap = new ConcurrentHashMap<UUID, Gang>();
        this.gangByNameMap = new ConcurrentHashMap<String, Gang>();
        this.gangByMemberMap = new ConcurrentHashMap<UUID, GangMember>();
    }

    protected void onLoad() {
        this.loadUI();
        this.loadRanks();
        this.loadLevels();
        if (!GangRanks.isPresent()) {
            throw new IllegalStateException("No gang ranks present!");
        }
        if (!GangLevels.isPresent()) {
            throw new IllegalStateException("No gang levels present!");
        }
        ((GangsPlugin)this.plugin).runTaskAsync(task -> this.loadGangs());
        this.addListener((SimpeListener)new GenericGangListener((GangsPlugin)this.plugin, this));
        if (Version.isPaper()) {
            this.addListener((SimpeListener)new PaperGangListener((GangsPlugin)this.plugin, this));
        } else {
            this.addListener((SimpeListener)new SpigotGangListener((GangsPlugin)this.plugin, this));
        }
        this.addAsyncTask(this::saveGangs, (Integer)Config.GENERAL_GANG_SAVE_INTERVAL.get());
    }

    protected void onShutdown() {
        this.saveGangs();
        this.gangByIdMap.clear();
        this.gangByNameMap.clear();
        this.gangByMemberMap.clear();
        GangRanks.clear();
        GangLevels.clear();
        this.loaded = false;
    }

    private void loadUI() {
        this.gangMenu = (GangMenu)this.addMenu((Menu)new GangMenu((GangsPlugin)this.plugin, this), "/menu/", "gang_main.yml");
        this.memberMenu = (MemberMenu)this.addMenu((Menu)new MemberMenu((GangsPlugin)this.plugin, this), "/menu/", "gang_member.yml");
        this.memberInventoryMenu = (MemberInventoryMenu)this.addMenu((Menu)new MemberInventoryMenu((GangsPlugin)this.plugin, this), "/menu/", "member_inventory.yml");
        this.vaultMenu = (VaultMenu)this.addMenu((Menu)new VaultMenu((GangsPlugin)this.plugin, this), "/menu/", "gang_vault.yml");
        this.levelsMenu = (LevelsMenu)this.addMenu((Menu)new LevelsMenu((GangsPlugin)this.plugin, this), "/menu/", "gang_levels.yml");
    }

    private void loadRanks() {
        FileConfig config = FileConfig.load((String)((GangsPlugin)this.plugin).getDataFolder().getAbsolutePath(), (String)"ranks.yml");
        this.loadRanks(config, "");
        config.saveChanges();
    }

    private void loadRanks(@NotNull FileConfig config, @NotNull String path) {
        if (config.getSection(path).isEmpty()) {
            GangDefaults.getDefaultRanks().forEach(rank -> config.set(path + "." + rank.getId(), rank));
        }
        config.getSection(path).forEach(sId -> {
            String id = Strings.varStyle((String)sId).orElse(null);
            if (id == null) {
                ((GangsPlugin)this.plugin).error("Invalid rank ID '" + sId + "'!");
                return;
            }
            GangRank rank = GangRank.read(config, path + "." + sId, id);
            GangRanks.register(rank);
        });
        GangRanks.updateInheritance();
        ((GangsPlugin)this.plugin).info("Loaded " + GangRanks.countRegistered() + " ranks.");
    }

    private void loadLevels() {
        FileConfig config = FileConfig.load((String)((GangsPlugin)this.plugin).getDataFolder().getAbsolutePath(), (String)"levels.yml");
        this.loadLevels(config, "");
        config.saveChanges();
    }

    private void loadLevels(@NotNull FileConfig config, @NotNull String path) {
        if (config.getSection(path).isEmpty()) {
            GangDefaults.getDefaultLevels().forEach(level -> config.set(path + "." + level.getValue(), level));
        }
        GangLevelLoader levelLoader = new GangLevelLoader((GangsPlugin)this.plugin, this.requirementFactory);
        for (String sId : config.getSection(path)) {
            int value = Numbers.getAnyInteger((String)sId, (int)0);
            if (value <= 0) {
                ((GangsPlugin)this.plugin).error("Invalid gang's level value '" + sId + "'.");
                continue;
            }
            GangLevel level2 = levelLoader.loadFromConfig(config, path + "." + sId, value);
            GangLevels.register(level2);
        }
        GangLevels.updateInheritance();
        ((GangsPlugin)this.plugin).info("Loaded " + GangLevels.count() + " levels.");
    }

    private void loadGangs() {
        ((GangsPlugin)this.plugin).getDataHandler().selectGangs().forEach(this::addGang);
        ((GangsPlugin)this.plugin).info("Loaded " + this.gangByIdMap.size() + " gangs.");
        this.loaded = true;
        ((GangsPlugin)this.plugin).getDataHandler().loadGangVaults().forEach(gangVault -> this.gangById(gangVault.getGangId()).ifPresent(gang -> gang.setVault((GangVault)gangVault)));
    }

    private void addGang(@NotNull Gang gang) {
        this.gangByIdMap.put(gang.getId(), gang);
        this.updateGangName(gang);
        gang.getMembers().forEach(member -> this.updatePlayerGang(member.getPlayerId(), (GangMember)member));
    }

    private void removeGang(@NotNull Gang gang) {
        this.gangByIdMap.remove(gang.getId());
        this.gangByNameMap.remove(gang.getIdName());
        gang.getMemberIds().forEach(this.gangByMemberMap::remove);
    }

    private void updatePlayerGang(@NotNull UUID playerId, @Nullable GangMember member) {
        if (member == null) {
            this.gangByMemberMap.remove(playerId);
        } else {
            this.gangByMemberMap.put(playerId, member);
        }
    }

    private void updateGangName(@NotNull Gang gang) {
        this.gangByNameMap.put(gang.getIdName(), gang);
    }

    private void saveGangs() {
        Set<Gang> gangs = this.getGangs().stream().filter(Gang::isDirty).peek(Gang::markClean).collect(Collectors.toSet());
        ((GangsPlugin)this.plugin).getDataHandler().updateGangs(gangs);
    }

    public boolean openGangMenu(@NotNull Player player) {
        Gang gang = this.getPlayerGang(player);
        if (gang == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        this.gangMenu.open(player, gang);
        return true;
    }

    public boolean openMemberMenu(@NotNull Player player, @NotNull GangMember member) {
        Gang gang = member.getGang();
        if (!gang.isMember(member.getPlayerId())) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        return this.openGangMenu(player, gang, this.memberMenu, menu -> menu.open(player, member));
    }

    public boolean openLevelsMenu(@NotNull Player player, @NotNull Gang gang) {
        return this.openGangMenu(player, gang, this.levelsMenu, menu -> menu.open(player, gang));
    }

    private <T> boolean openGangMenu(@NotNull Player player, @NotNull Gang gang, @NotNull T menu, @NotNull Consumer<T> consumer) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        consumer.accept(menu);
        return true;
    }

    public void handleJoin(@NotNull Player player) {
        GangMember member = this.getGangMember(player);
        if (member == null) {
            return;
        }
        member.update(player);
    }

    public void handleQuit(@NotNull Player player) {
        GangMember member = this.getGangMember(player);
        if (member == null) {
            return;
        }
        member.update(player);
    }

    private boolean checkNameLength(@NotNull Player player, @NotNull String clean, @NotNull String idName) {
        int max = (Integer)Config.GANG_NAME_LENGTH_MAX.get();
        if (clean.length() > max) {
            Lang.GANG_CREATION_NAME_TOO_LONG.message().send((CommandSender)player, replacer -> replacer.replace("%amount%", (Object)max));
            return false;
        }
        int min = (Integer)Config.GANG_NAME_LENGTH_MIN.get();
        if (clean.length() < min || idName.length() < min) {
            Lang.GANG_CREATION_NAME_TOO_SHORT.message().send((CommandSender)player, replacer -> replacer.replace("%amount%", (Object)min));
            return false;
        }
        return true;
    }

    public boolean openCreationDialog(@NotNull Player player) {
        if (!this.loaded) {
            Lang.ERROR_DATA_NOT_LOADED.message().send((CommandSender)player);
            return false;
        }
        if (this.isInGang(player)) {
            Lang.GANG_ERROR_ALREADY_IN.message().send((CommandSender)player);
            return false;
        }
        GangDialogs.GANG_CREATE.ifPresent(dialog -> dialog.show(player, this, () -> {}));
        return true;
    }

    public boolean createGang(@NotNull Player player, @NotNull String name) {
        if (!this.loaded) {
            Lang.ERROR_DATA_NOT_LOADED.message().send((CommandSender)player);
            return false;
        }
        if (this.isInGang(player)) {
            Lang.GANG_ERROR_ALREADY_IN.message().send((CommandSender)player);
            return false;
        }
        String clean = NightMessage.stripTags((String)name);
        String idName = Strings.varStyle((String)clean).orElse(null);
        if (idName == null || !GangUtils.isValidName(clean)) {
            Lang.GANG_CREATION_NAME_INVALID.message().send((CommandSender)player, replacer -> replacer.replace("%name%", (Object)name));
            return false;
        }
        if (!this.checkNameLength(player, clean, idName)) {
            return false;
        }
        if (this.isGangExists(idName)) {
            Lang.GANG_ERROR_ALREADY_EXISTS.message().send((CommandSender)player);
            return false;
        }
        UUID id = UUID.randomUUID();
        GangRank rank = GangRanks.getHighestRank();
        GangLevel level = GangLevels.getFirst();
        GangBank bank = GangBank.create();
        Gang gang = new Gang(id, idName, clean, player.getUniqueId(), level, bank, false, new HashMap<UUID, GangMember>());
        gang.addMember(GangMember.create(player, rank));
        gang.setVault(GangVault.create(gang));
        ((GangsPlugin)this.plugin).runTaskAsync(task -> {
            ((GangsPlugin)this.plugin).getDataHandler().insertGang(gang);
            this.addGang(gang);
        });
        Lang.GANG_CREATION_SUCCESS.message().send((CommandSender)player, replacer -> replacer.replace(gang.replacePlaceholders()));
        return true;
    }

    public boolean renameGang(@NotNull Player player, @NotNull Gang gang, @NotNull String name) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.RENAME)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (!gang.getLevel().hasFeature(LevelFeature.RENAMING)) {
            gang.sendMessage(Lang.GANG_ERROR_LEVEL_RESTRICTION, (CommandSender)player);
            return false;
        }
        String clean = NightMessage.stripTags((String)name);
        String idName = Strings.varStyle((String)clean).orElse(null);
        if (idName == null || !GangUtils.isValidName(clean)) {
            Lang.GANG_CREATION_NAME_INVALID.message().send((CommandSender)player, replacer -> replacer.replace("%name%", (Object)name));
            return false;
        }
        if (!this.checkNameLength(player, clean, idName)) {
            return false;
        }
        if (this.isGangExists(idName)) {
            Lang.GANG_ERROR_ALREADY_EXISTS.message().send((CommandSender)player);
            return false;
        }
        gang.rename(idName, clean);
        gang.sendInternalMessage(Lang.GANG_NOTIFY_RENAME);
        gang.sendMessage(Lang.GANG_RENAME_SUCCESS, (CommandSender)player);
        ((GangsPlugin)this.plugin).runTaskAsync(task -> {
            ((GangsPlugin)this.plugin).getDataHandler().updateGang(gang);
            this.updateGangName(gang);
        });
        return true;
    }

    public boolean joinGang(@NotNull Player player, @NotNull Gang gang) {
        if (this.isInGang(player)) {
            Lang.GANG_ERROR_ALREADY_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.hasInvite(player)) {
            Lang.GANG_JOIN_NO_INVITE.message().send((CommandSender)player, replacer -> replacer.replace(gang.replacePlaceholders()));
            return false;
        }
        GangRank rank = GangRanks.getLowestRank();
        GangMember member = GangMember.create(player, rank);
        gang.addMember(member);
        gang.sendMessage(Lang.GANG_JOIN_SUCCESS, (CommandSender)player, replacer -> replacer.replace(gang.replacePlaceholders()));
        gang.sendInternalMessage(Lang.GANG_NOTIFY_MEMBER_JOINED, replacer -> replacer.replace(member.replacePlaceholders()));
        gang.removeInvite(player.getUniqueId());
        gang.markDirty();
        this.updatePlayerGang(player.getUniqueId(), member);
        return true;
    }

    public boolean leaveGang(@NotNull Player player) {
        GangMember member = this.getGangMember(player);
        if (member == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        Gang gang = member.getGang();
        if (gang.isOwner(player)) {
            gang.sendMessage(Lang.GANG_LEAVE_OWNER, (CommandSender)player);
            return false;
        }
        gang.removeMember(player);
        gang.sendInternalMessage(Lang.GANG_NOTIFY_MEMBER_LEFT, replacer -> replacer.replace(member.replacePlaceholders()));
        gang.markDirty();
        this.updatePlayerGang(player.getUniqueId(), null);
        Lang.GANG_LEAVE_SUCCESS.message().send((CommandSender)player, replacer -> replacer.replace(gang.replacePlaceholders()));
        return true;
    }

    public boolean inviteToGang(@NotNull Player sourcePlayer, @NotNull Player targetPlayer) {
        Gang gang = this.getPlayerGang(sourcePlayer);
        if (gang == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)sourcePlayer);
            return false;
        }
        if (!gang.isPermitted(sourcePlayer, GangPermission.INVITE_MEMBER)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)sourcePlayer);
            return false;
        }
        if (sourcePlayer == targetPlayer) {
            gang.sendMessage(Lang.GANG_ERROR_NOT_YOURSELF, (CommandSender)sourcePlayer);
            return false;
        }
        if (this.isInGang(targetPlayer)) {
            gang.sendMessage(Lang.GANG_INVITE_ALREADY_IN, (CommandSender)sourcePlayer, replacer -> replacer.replace(GangsPlaceholders.forPlayer((Player)targetPlayer)));
            return false;
        }
        if (gang.hasInvite(targetPlayer)) {
            gang.sendMessage(Lang.GANG_INVITE_ALREADY_HAS, (CommandSender)sourcePlayer, replacer -> replacer.replace(GangsPlaceholders.forPlayer((Player)targetPlayer)));
            return false;
        }
        gang.addInvite(new GangInvite(targetPlayer.getUniqueId(), TimeUtil.createFutureTimestamp((double)((Integer)Config.GANG_INVITE_EXPIRE_TIME.get()).intValue())));
        gang.sendMessage(Lang.GANG_INVITE_SENT, (CommandSender)sourcePlayer, replacer -> replacer.replace(GangsPlaceholders.forPlayer((Player)targetPlayer)));
        Lang.GANG_INVITE_RECEIVED.message().send((CommandSender)targetPlayer, replacer -> replacer.replace(gang.replacePlaceholders()).replace(GangsPlaceholders.forPlayer((Player)sourcePlayer)));
        return true;
    }

    public boolean kickMember(@NotNull Player player, @NotNull GangMember targetMember) {
        GangMember sourceMember = this.getGangMember(player);
        if (sourceMember == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        Gang gang = sourceMember.getGang();
        if (!gang.isPermitted(player, GangPermission.KICK_MEMBER)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (targetMember.isPlayer(player)) {
            gang.sendMessage(Lang.GANG_ERROR_NOT_YOURSELF, (CommandSender)player);
            return false;
        }
        if (!targetMember.isGang(gang)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_MEMBER, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        if (targetMember.getRank().isAboveOrEqual(sourceMember.getRank())) {
            gang.sendMessage(Lang.GANG_KICK_HIGH_RANK, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        gang.removeMember(targetMember);
        gang.sendMessage(Lang.GANG_KICK_SUCCESS, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        gang.sendInternalMessage(Lang.GANG_NOTIFY_MEMBER_KICKED, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        gang.markDirty();
        this.updatePlayerGang(targetMember.getPlayerId(), null);
        return true;
    }

    public boolean promoteMember(@NotNull Player player, @NotNull GangMember targetMember) {
        GangRank targetRank;
        GangMember sourceMember = this.getGangMember(player);
        if (sourceMember == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        Gang gang = sourceMember.getGang();
        if (!gang.isPermitted(player, GangPermission.PROMOTE_MEMBER)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (targetMember.isPlayer(player)) {
            gang.sendMessage(Lang.GANG_ERROR_NOT_YOURSELF, (CommandSender)player);
            return false;
        }
        if (!targetMember.isGang(gang)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_MEMBER, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        GangRank sourceRank = sourceMember.getRank();
        if (!sourceRank.isAbove(targetRank = targetMember.getRank())) {
            gang.sendMessage(Lang.GANG_PROMOTE_MEMBER_WITH_HIGHER_RANK, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        GangRank nextRank = GangRanks.getNextRank(targetRank);
        if (nextRank == null || !sourceRank.isAbove(nextRank)) {
            gang.sendMessage(Lang.GANG_PROMOTE_MEMBER_WITH_MAX_RANK, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        targetMember.setRank(nextRank);
        gang.markDirty();
        gang.sendInternalMessage(Lang.GANG_NOTIFY_MEMBER_PROMOTED, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        gang.sendMessage(Lang.GANG_PROMOTE_SUCCESS, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        return true;
    }

    public boolean demoteMember(@NotNull Player player, @NotNull GangMember targetMember) {
        GangRank targetRank;
        GangMember sourceMember = this.getGangMember(player);
        if (sourceMember == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        Gang gang = sourceMember.getGang();
        if (!gang.isPermitted(player, GangPermission.DEMOTE_MEMBER)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (targetMember.isPlayer(player)) {
            gang.sendMessage(Lang.GANG_ERROR_NOT_YOURSELF, (CommandSender)player);
            return false;
        }
        if (!targetMember.isGang(gang)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_MEMBER, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        GangRank sourceRank = sourceMember.getRank();
        if (!sourceRank.isAbove(targetRank = targetMember.getRank())) {
            gang.sendMessage(Lang.GANG_DEMOTE_MEMBER_WITH_HIGHER_RANK, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        GangRank previousRank = GangRanks.getPreviousRank(targetRank);
        if (previousRank == null) {
            gang.sendMessage(Lang.GANG_DEMOTE_MEMBER_WITH_MIN_RANK, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        targetMember.setRank(previousRank);
        gang.markDirty();
        gang.sendInternalMessage(Lang.GANG_NOTIFY_MEMBER_DEMOTED, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        gang.sendMessage(Lang.GANG_DEMOTE_SUCCESS, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        return true;
    }

    public boolean transferGang(@NotNull Player player, @NotNull GangMember targetMember) {
        GangMember sourceMember = this.getGangMember(player);
        if (sourceMember == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        Gang gang = sourceMember.getGang();
        if (!gang.isOwner(player)) {
            gang.sendMessage(Lang.GANG_ERROR_OWNER_ONLY, (CommandSender)player);
            return false;
        }
        if (targetMember.isPlayer(player)) {
            gang.sendMessage(Lang.GANG_ERROR_NOT_YOURSELF, (CommandSender)player);
            return false;
        }
        if (!targetMember.isGang(gang)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_MEMBER, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        GangRank sourceRank = sourceMember.getRank();
        GangRank previousRank = GangRanks.getPreviousRank(sourceRank);
        GangRank bestRank = GangRanks.getHighestRank();
        sourceMember.setRank(previousRank == null ? GangRanks.getLowestRank() : previousRank);
        targetMember.setRank(bestRank);
        gang.setOwnerId(targetMember.getPlayerId());
        gang.markDirty();
        gang.sendInternalMessage(Lang.GANG_NOTIFY_TRANSFER, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        gang.sendMessage(Lang.GANG_TRANSFERRED, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        return true;
    }

    public boolean viewMemberInventory(@NotNull Player player, @NotNull Gang gang, @NotNull GangMember targetMember) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!targetMember.isGang(gang)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_MEMBER, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.VIEW_MEMBER_INVENTORY)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (targetMember.isPlayer(player)) {
            gang.sendMessage(Lang.GANG_ERROR_NOT_YOURSELF, (CommandSender)player);
            return false;
        }
        this.memberInventoryMenu.open(player, targetMember);
        return true;
    }

    public boolean viewVault(@NotNull Player player, @NotNull Gang gang) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.VIEW_VAULT)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (!gang.isVaultUnlocked()) {
            Lang.GANG_VAULT_LOCKED.message().send((CommandSender)player);
            return false;
        }
        if (!gang.hasVault()) {
            Lang.ERROR_DATA_NOT_LOADED.message().send((CommandSender)player);
            return false;
        }
        GangVault vault = gang.getVault();
        if (vault.isInUse()) {
            gang.sendMessage(Lang.GANG_VAULT_IN_USE, (CommandSender)player);
            return false;
        }
        this.vaultMenu.open(player, vault, viewer -> vault.setInUse(true));
        return true;
    }

    public boolean viewBank(@NotNull Player player, @NotNull Gang gang, @NotNull Runnable callback) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.VIEW_BANK)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        GangDialogs.GANG_BANK.ifPresent(dialog -> dialog.show(player, gang, callback));
        return true;
    }

    public boolean depositToBank(@NotNull Player player, @NotNull Gang gang, @NotNull Currency currency, double amount) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.DEPOSIT_TO_BANK)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (currency.getBalance(player) < amount) {
            gang.sendMessage(Lang.GANG_BANK_DEPOSIT_NOT_ENOUGH, (CommandSender)player, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)));
            return false;
        }
        currency.take(player, amount);
        gang.getBank().deposit(currency, amount);
        gang.markDirty();
        gang.sendMessage(Lang.GANG_BANK_DEPOSIT_SUCCESS, (CommandSender)player, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)));
        return true;
    }

    public boolean withdrawFromBank(@NotNull Player player, @NotNull Gang gang, @NotNull Currency currency, double amount) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.WITHDRAW_FROM_BANK)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        GangBank bank = gang.getBank();
        if (!bank.hasEnough(currency, amount)) {
            gang.sendMessage(Lang.GANG_BANK_WITHDRAW_NOT_ENOUGH, (CommandSender)player, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)));
            return false;
        }
        currency.give(player, amount);
        gang.getBank().withdraw(currency, amount);
        gang.markDirty();
        gang.sendMessage(Lang.GANG_BANK_WITHDRAW_SUCCESS, (CommandSender)player, replacer -> replacer.replace("%amount%", (Object)currency.format(amount)));
        return true;
    }

    public boolean teleportToMember(@NotNull Player player, @NotNull GangMember targetMember) {
        GangMember sourceMember = this.getGangMember(player);
        if (sourceMember == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        Gang gang = sourceMember.getGang();
        if (!gang.isPermitted(player, GangPermission.TELEPORT_TO_MEMBER)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        if (targetMember.isPlayer(player)) {
            gang.sendMessage(Lang.GANG_ERROR_NOT_YOURSELF, (CommandSender)player);
            return false;
        }
        if (!targetMember.isGang(gang)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_MEMBER, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        Player target = targetMember.getPlayer();
        if (target == null) {
            gang.sendMessage(Lang.GANG_TELEPORT_OFFLINE, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        if (!player.teleport((Entity)target)) {
            gang.sendMessage(Lang.GANG_TELEPORT_FAILURE, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
            return false;
        }
        gang.sendMessage(Lang.GANG_TELEPORT_SUCCESS, (CommandSender)player, replacer -> replacer.replace(targetMember.replacePlaceholders()));
        gang.sendMessage(Lang.GANG_TELEPORT_NOTIFY, (CommandSender)target, replacer -> replacer.replace(sourceMember.replacePlaceholders()));
        return true;
    }

    public boolean toggleFriendlyFire(@NotNull Player player, @NotNull Gang gang) {
        GangMember member = gang.getMember(player);
        if (member == null) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.TOGGLE_FRIENDLY_FIRE)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        gang.setFriendlyFire(!gang.isFriendlyFire());
        gang.sendInternalMessage(Lang.GANG_NOTIFY_FRIENDLY_FIRE, replacer -> replacer.replace(member.replacePlaceholders()));
        gang.sendMessage(Lang.GANG_FRIENDLY_FIRE_TOGGLED, (CommandSender)player);
        gang.markDirty();
        return true;
    }

    public boolean upgradeLevel(@NotNull Player player, @NotNull Gang gang) {
        if (!gang.isMember(player)) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        if (!gang.isPermitted(player, GangPermission.UPGRADE_LEVEL)) {
            gang.sendMessage(Lang.GANG_ERROR_NO_PERMISSION, (CommandSender)player);
            return false;
        }
        GangLevel level = gang.getLevel();
        GangLevel nextLevel = GangLevels.getNext(level);
        if (nextLevel == null) {
            gang.sendMessage(Lang.GANG_UPGRADE_MAX_LEVEL, (CommandSender)player);
            return false;
        }
        if (!nextLevel.isMetRequirements(gang)) {
            gang.sendMessage(Lang.GANG_UPGRADE_REQUIREMENTS_NOT_MET, (CommandSender)player);
            return false;
        }
        nextLevel.payForUpgrade(gang);
        gang.level(nextLevel);
        gang.markDirty();
        gang.sendInternalMessage(Lang.GANG_NOTIFY_UPGRADE);
        gang.sendMessage(Lang.GANG_UPGRADE_SUCCESS, (CommandSender)player);
        return true;
    }

    public boolean disbandGang(@NotNull Player player) {
        GangMember member = this.getGangMember(player);
        if (member == null || !member.hasGang()) {
            Lang.GANG_ERROR_NOT_IN.message().send((CommandSender)player);
            return false;
        }
        Gang gang = member.getGang();
        if (!gang.isOwner(player)) {
            gang.sendMessage(Lang.GANG_ERROR_OWNER_ONLY, (CommandSender)player);
            return false;
        }
        gang.getBank().getBalanceMap().forEach((id, amount) -> EconomyBridge.deposit((Player)player, (String)id, (double)amount));
        gang.getBank().clear();
        gang.sendInternalMessage(Lang.GANG_NOTIFY_DISBAND, replacer -> replacer.replace(member.replacePlaceholders()));
        gang.sendMessage(Lang.GANG_DISBAND_SUCCESS, (CommandSender)player, replacer -> replacer.replace(gang.replacePlaceholders()));
        gang.markClean();
        this.removeGang(gang);
        ((GangsPlugin)this.plugin).runTaskAsync(task -> ((GangsPlugin)this.plugin).getDataHandler().deleteGang(gang));
        return true;
    }

    public boolean isInGang(@NotNull Player player) {
        return this.isInGang(player.getUniqueId());
    }

    public boolean isInGang(@NotNull UUID playerId) {
        return this.getGangMember(playerId) != null;
    }

    public boolean isGangExists(@NotNull String idName) {
        return this.gangByNameMap.containsKey(idName);
    }

    @Nullable
    public GangMember getGangMember(@NotNull Player player) {
        return this.getGangMember(player.getUniqueId());
    }

    @Nullable
    public GangMember getGangMember(@NotNull UUID playerId) {
        return this.gangByMemberMap.get(playerId);
    }

    @Nullable
    public Gang getPlayerGang(@NotNull Player player) {
        return this.getPlayerGang(player.getUniqueId());
    }

    @Nullable
    public Gang getPlayerGang(@NotNull UUID playerId) {
        GangMember member = this.getGangMember(playerId);
        return member == null ? null : member.getGang();
    }

    @NotNull
    public Optional<Gang> gangById(@NotNull UUID id) {
        return Optional.ofNullable(this.getGangById(id));
    }

    @Nullable
    public Gang getGangById(@NotNull UUID id) {
        return this.gangByIdMap.get(id);
    }

    @NotNull
    public Optional<Gang> gangByName(@NotNull String name) {
        return Optional.ofNullable(this.getGangByName(name));
    }

    @Nullable
    public Gang getGangByName(@NotNull String name) {
        return this.gangByNameMap.get(name);
    }

    @NotNull
    public Set<Gang> getGangs() {
        return new HashSet<Gang>(this.gangByIdMap.values());
    }

    @NotNull
    public List<String> getGangIdNames() {
        return new ArrayList<String>(this.gangByNameMap.keySet());
    }

    @NotNull
    public Map<UUID, Gang> getGangByIdMap() {
        return this.gangByIdMap;
    }

    @NotNull
    public Map<String, Gang> getGangByNameMap() {
        return this.gangByNameMap;
    }

    @NotNull
    public Map<UUID, GangMember> getGangByMemberMap() {
        return this.gangByMemberMap;
    }
}

