/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang;

import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentgangs.GangsPlaceholders;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.gang.rank.GangRank;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.profile.CachedProfile;
import su.nightexpress.nightcore.util.profile.PlayerProfiles;

public class GangMember {
    private final UUID playerId;
    private String playerName;
    private Gang gang;
    private GangRank rank;
    private long lastLogin;

    public GangMember(@NotNull UUID playerId, @NotNull String playerName, @NotNull GangRank rank, long lastLogin) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.setRank(rank);
        this.setLastLogin(lastLogin);
    }

    @NotNull
    public static GangMember create(@NotNull Player player, @NotNull GangRank rank) {
        return new GangMember(player.getUniqueId(), player.getName(), rank, System.currentTimeMillis());
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return GangsPlaceholders.MEMBER.replacer((Object)this);
    }

    public void update(@NotNull Player player) {
        this.setLastLogin(System.currentTimeMillis());
        this.playerName = player.getName();
    }

    public boolean isPermitted(@NotNull GangPermission permission) {
        return this.rank.isPermitted(permission);
    }

    public boolean hasGang() {
        return this.gang != null;
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public boolean isPlayer(@NotNull Player player) {
        return this.playerId.equals(player.getUniqueId());
    }

    public boolean isGang(@NotNull Gang gang) {
        return this.gang == gang;
    }

    @NotNull
    public CachedProfile getProfile() {
        return PlayerProfiles.createProfile((UUID)this.playerId, (String)this.playerName);
    }

    @Nullable
    public Player getPlayer() {
        return Players.getPlayer((UUID)this.playerId);
    }

    @NotNull
    public Optional<Player> player() {
        return Optional.ofNullable(this.getPlayer());
    }

    @NotNull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public String getName() {
        return this.playerName;
    }

    @NotNull
    public Gang getGang() {
        if (!this.hasGang()) {
            throw new IllegalStateException("Gang is not assigned");
        }
        return this.gang;
    }

    public void setGang(@Nullable Gang gang) {
        this.gang = gang;
    }

    @NotNull
    public GangRank getRank() {
        return this.rank;
    }

    public void setRank(@NotNull GangRank rank) {
        this.rank = rank;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }
}

