/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.bank;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;

public class GangBank {
    private final Map<String, Double> balanceMap;

    public GangBank(@NotNull Map<String, Double> balanceMap) {
        this.balanceMap = balanceMap;
    }

    @NotNull
    public static GangBank create() {
        return new GangBank(new HashMap<String, Double>());
    }

    public void clear() {
        this.balanceMap.clear();
    }

    public boolean isEmpty() {
        return this.balanceMap.isEmpty() || this.balanceMap.values().stream().allMatch(amount -> amount == 0.0);
    }

    @NotNull
    public String formatBalances(@NotNull String delimiter) {
        return this.balanceMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> EconomyBridge.currency((String)((String)entry.getKey())).map(currency -> currency.format(((Double)entry.getValue()).doubleValue())).orElse(null)).filter(Objects::nonNull).collect(Collectors.joining(delimiter));
    }

    public boolean hasEnough(@NotNull Currency currency, double amount) {
        return this.hasEnough(currency.getInternalId(), amount);
    }

    public boolean hasEnough(@NotNull String currencyId, double amount) {
        return this.getBalance(currencyId) >= amount;
    }

    public double getBalance(@NotNull Currency currency) {
        return this.getBalance(currency.getInternalId());
    }

    public double getBalance(@NotNull String currencyId) {
        return this.balanceMap.getOrDefault(currencyId, 0.0);
    }

    public void deposit(@NotNull Currency currency, double amount) {
        this.deposit(currency.getInternalId(), amount);
    }

    public void deposit(@NotNull String currencyId, double amount) {
        this.setBalance(currencyId, this.getBalance(currencyId) + amount);
    }

    public void withdraw(@NotNull Currency currency, double amount) {
        this.withdraw(currency.getInternalId(), amount);
    }

    public void withdraw(@NotNull String currencyId, double amount) {
        this.setBalance(currencyId, this.getBalance(currencyId) - amount);
    }

    public void setBalance(@NotNull Currency currency, double amount) {
        this.setBalance(currency.getInternalId(), amount);
    }

    public void setBalance(@NotNull String currencyId, double amount) {
        this.balanceMap.put(currencyId, Math.max(0.0, amount));
    }

    @NotNull
    public Map<String, Double> getBalanceMap() {
        return Map.copyOf(this.balanceMap);
    }
}

