/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.level;

import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlaceholders;
import su.nightexpress.excellentgangs.api.level.LevelFeature;
import su.nightexpress.excellentgangs.api.level.LevelRequirement;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.requirement.type.ConfigurableLevelRequirement;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class GangLevel
implements Writeable {
    private final int value;
    private final String displayName;
    private final NightItem icon;
    private final int maxMembers;
    private final int vaultSize;
    private final Set<LevelFeature> features;
    private final Set<LevelRequirement> upgradeRequirements;

    public GangLevel(int value, @NotNull String displayName, @NotNull NightItem icon, int maxMembers, int vaultSize, @NotNull Set<LevelFeature> features, @NotNull Set<LevelRequirement> upgradeRequirements) {
        this.value = value;
        this.displayName = displayName;
        this.icon = icon.copy();
        this.maxMembers = maxMembers;
        this.vaultSize = vaultSize;
        this.features = features;
        this.upgradeRequirements = upgradeRequirements;
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".DisplayName", (Object)this.displayName);
        config.set(path + ".Icon", (Object)this.icon);
        config.set(path + ".MaxMembers", (Object)this.maxMembers);
        config.set(path + ".VaultSize", (Object)this.vaultSize);
        config.set(path + ".Features", (Object)Lists.modify(this.features, Enum::name));
        config.remove(path + ".Requirements");
        this.upgradeRequirements.forEach(requirement -> {
            if (requirement instanceof ConfigurableLevelRequirement) {
                ConfigurableLevelRequirement levelRequirement = (ConfigurableLevelRequirement)requirement;
                config.set(path + ".Requirements." + levelRequirement.getId(), requirement);
            }
        });
    }

    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return GangsPlaceholders.LEVEL.replacer((Object)this);
    }

    public void inheritFeatures(@NotNull Set<LevelFeature> features) {
        this.features.addAll(features);
    }

    public boolean hasFeatures() {
        return !this.features.isEmpty();
    }

    public boolean isMetRequirements(@NotNull Gang gang) {
        return this.upgradeRequirements.stream().allMatch(requirement -> requirement.isMet(gang));
    }

    public void payForUpgrade(@NotNull Gang gang) {
        this.upgradeRequirements.forEach(requirement -> requirement.pay(gang));
    }

    public boolean isAboveOrEqual(@NotNull GangLevel other) {
        return this.isAbove(other) || this.isEqual(other);
    }

    public boolean isAbove(@NotNull GangLevel other) {
        return this.value > other.value;
    }

    public boolean isEqual(@NotNull GangLevel other) {
        return this.value == other.value;
    }

    public boolean isUnder(@NotNull GangLevel other) {
        return other.isAbove(this);
    }

    public boolean hasFeature(@NotNull LevelFeature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean hasRequirements() {
        return !this.upgradeRequirements.isEmpty();
    }

    public int getValue() {
        return this.value;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public NightItem getIcon() {
        return this.icon.copy();
    }

    public int getMaxMembers() {
        return this.maxMembers;
    }

    public int getVaultSize() {
        return this.vaultSize;
    }

    @NotNull
    public Set<LevelFeature> getFeatures() {
        return this.features;
    }

    @NotNull
    public Set<LevelRequirement> getUpgradeRequirements() {
        return this.upgradeRequirements;
    }
}

