/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.level;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.api.level.LevelFeature;
import su.nightexpress.excellentgangs.api.level.LevelRequirement;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.excellentgangs.requirement.LevelRequirementFactory;
import su.nightexpress.excellentgangs.requirement.type.ConfigurableLevelRequirement;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class GangLevelLoader {
    private final GangsPlugin plugin;
    private final LevelRequirementFactory requirementFactory;

    public GangLevelLoader(@NotNull GangsPlugin plugin, @NotNull LevelRequirementFactory requirementFactory) {
        this.plugin = plugin;
        this.requirementFactory = requirementFactory;
    }

    @NotNull
    public GangLevel loadFromConfig(@NotNull FileConfig config, @NotNull String path, int value) {
        String displayName = (String)ConfigValue.create((String)(path + ".DisplayName"), (String)String.valueOf(value), (String[])new String[0]).read(config);
        NightItem icon = (NightItem)ConfigValue.create((String)(path + ".Icon"), (NightItem)NightItem.fromType((Material)Material.EMERALD), (String[])new String[0]).read(config);
        int maxMembers = (Integer)ConfigValue.create((String)(path + ".MaxMembers"), (int)4, (String[])new String[0]).read(config);
        int vaultSize = (Integer)ConfigValue.create((String)(path + ".VaultSize"), (int)9, (String[])new String[0]).read(config);
        Set features = Lists.modify((Set)config.getStringSet(path + ".Features"), raw -> (LevelFeature)Enums.get((String)raw, LevelFeature.class));
        features.removeIf(Objects::isNull);
        HashSet<LevelRequirement> upgradeRequirements = new HashSet<LevelRequirement>();
        config.getSection(path + ".Requirements").forEach(sId -> {
            try {
                ConfigurableLevelRequirement requirement = this.requirementFactory.parse(config, path + ".Requirements." + sId, (String)sId);
                upgradeRequirements.add(requirement);
            }
            catch (IllegalArgumentException exception) {
                this.plugin.error(String.format("Could not load a level requirement in '%s'. Reason: %s", config.getPath(), exception.getMessage()));
            }
        });
        return new GangLevel(value, displayName, icon, maxMembers, vaultSize, features, upgradeRequirements);
    }
}

