/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.listener;

import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;

public class GenericGangListener
extends AbstractListener<GangsPlugin> {
    private final GangManager manager;

    public GenericGangListener(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightCorePlugin)plugin);
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(@NotNull PlayerJoinEvent event) {
        this.manager.handleJoin(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(@NotNull PlayerQuitEvent event) {
        this.manager.handleQuit(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Gang gang = this.manager.getPlayerGang(victim);
        if (gang == null) {
            return;
        }
        DamageSource source = event.getDamageSource();
        Entity entity2 = source.getCausingEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player damager = (Player)entity2;
        if (gang.isMember(damager) && !gang.isFriendlyFire()) {
            event.setCancelled(true);
        }
    }
}

