/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.listener;

import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlaceholders;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.config.Perms;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class PaperGangListener
extends AbstractListener<GangsPlugin> {
    private final GangManager manager;

    public PaperGangListener(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightCorePlugin)plugin);
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        GangMember member = this.manager.getGangMember(player);
        if (member == null || !member.hasGang()) {
            return;
        }
        String prefix = (String)Config.CHAT_PREFIX.get();
        String originalMessage = (String)MiniMessage.miniMessage().serialize(event.originalMessage());
        if (!originalMessage.startsWith(prefix)) {
            return;
        }
        Gang gang = member.getGang();
        String format = (String)Config.CHAT_FORMAT.get();
        String fullFormat = Replacer.create().replace(gang.replacePlaceholders()).replace(member.replacePlaceholders()).replace(GangsPlaceholders.forPlaceholderAPI((Player)player)).replace("%message%", (Object)originalMessage.substring(prefix.length()).trim()).apply(format);
        event.renderer((source, sourceDisplayName, message, viewer) -> (Component)Software.get().getTextComponentAdapter().adaptComponent(NightMessage.parse((String)fullFormat)));
        event.viewers().removeIf(audience -> {
            Player other;
            return audience instanceof Player && !gang.isMember(other = (Player)audience) && !other.hasPermission((Permission)Perms.CHAT_SPY);
        });
    }
}

