/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.listener;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.placeholder.Replacer;

public class SpigotGangListener
extends AbstractListener<GangsPlugin> {
    private final GangManager manager;

    public SpigotGangListener(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightCorePlugin)plugin);
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        GangMember member = this.manager.getGangMember(player);
        if (member == null || !member.hasGang()) {
            return;
        }
        String prefix = (String)Config.CHAT_PREFIX.get();
        String plainMessage = event.getMessage();
        if (!plainMessage.startsWith(prefix)) {
            return;
        }
        Gang gang = member.getGang();
        String format = (String)Config.CHAT_FORMAT.get();
        String fullFormat = Replacer.create().replace(gang.replacePlaceholders()).replace(member.replacePlaceholders()).replace("%player_name%", (Object)"%1$s").replace("%message%", (Object)"%2$s").apply(format);
        event.setMessage(plainMessage.substring(prefix.length()).trim());
        event.setFormat(fullFormat);
        event.getRecipients().removeIf(recipient -> !gang.isMember((Player)recipient));
    }
}

