/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.menu;

import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlaceholders;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.api.level.LevelFeature;
import su.nightexpress.excellentgangs.config.Lang;
import su.nightexpress.excellentgangs.dialog.GangDialogs;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.registry.GangLevels;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class GangMenu
extends LinkedMenu<GangsPlugin, Gang>
implements ConfigBased {
    private final GangManager manager;
    private NightItem memberSelfIcon;
    private NightItem memberOnlineIcon;
    private NightItem memberOfflineIcon;
    private NightItem memberInviteIcon;
    private NightItem memberLockedIcon;
    private NightItem memberEmptyIcon;
    private int[] memberSlots;
    private NightItem friendlyFireIcon;
    private int friendlyFireSlot;
    private NightItem disbandIcon;
    private int disbandSlot;
    private NightItem nameIcon;
    private NightItem nameLockedIcon;
    private int nameSlot;
    private NightItem vaultIcon;
    private NightItem vaultLockedIcon;
    private int vaultSlot;
    private NightItem bankIcon;
    private int bankSlot;
    private NightItem levelsIcon;
    private int levelsSlot;

    public GangMenu(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X6, TagWrappers.BLACK.wrap("Gang Menu"));
        this.manager = manager;
        this.setApplyPlaceholderAPI(true);
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        Gang gang = (Gang)this.getLink(player);
        List<GangMember> members = gang.getMembers().stream().sorted(Comparator.comparingInt(m -> m.getRank().getPriority()).reversed().thenComparing(GangMember::getName)).toList();
        for (int index = 0; index < this.memberSlots.length; ++index) {
            int slot = this.memberSlots[index];
            if (index >= members.size()) {
                boolean isAboveLimit;
                int maxSlots = gang.getMembersLimit();
                boolean canInvite = gang.isPermitted(player, GangPermission.INVITE_MEMBER);
                boolean bl = isAboveLimit = index + 1 > maxSlots;
                viewer.addItem((!canInvite ? this.memberEmptyIcon : (!isAboveLimit ? this.memberInviteIcon : this.memberLockedIcon)).copy().toMenuItem().setSlots(new int[]{slot}).setPriority(Integer.MAX_VALUE).setHandler((viewer1, event) -> this.handleInvite(player, gang, canInvite && !isAboveLimit)).build());
                continue;
            }
            GangMember member = members.get(index);
            boolean isOnline = member.isOnline();
            boolean isSelf = member.isPlayer(player);
            Player memberPlayer = member.getPlayer();
            viewer.addItem((isSelf ? this.memberSelfIcon : (isOnline ? this.memberOnlineIcon : this.memberOfflineIcon)).copy().replacement(replacer -> {
                replacer.replace(member.replacePlaceholders());
                if (memberPlayer != null) {
                    replacer.replace(GangsPlaceholders.forPlaceholderAPI((Player)memberPlayer));
                }
            }).setPlayerProfile(member.getProfile()).toMenuItem().setPriority(Integer.MAX_VALUE).setSlots(new int[]{slot}).setHandler((viewer1, event) -> {
                if (isSelf) {
                    return;
                }
                this.runNextTick(() -> this.manager.openMemberMenu(player, member));
            }).build());
        }
        if (gang.isPermitted(player, GangPermission.TOGGLE_FRIENDLY_FIRE)) {
            viewer.addItem(this.friendlyFireIcon.copy().hideAllComponents().replacement(replacer -> replacer.replace(gang.replacePlaceholders())).toMenuItem().setSlots(new int[]{this.friendlyFireSlot}).setHandler((viewer1, event) -> this.handleFriendlyFire(player, gang)).build());
        }
        if (gang.isPermitted(player, GangPermission.RENAME)) {
            viewer.addItem((gang.getLevel().hasFeature(LevelFeature.RENAMING) ? this.nameIcon : this.nameLockedIcon).copy().hideAllComponents().replacement(replacer -> replacer.replace(gang.replacePlaceholders())).toMenuItem().setSlots(new int[]{this.nameSlot}).setHandler((viewer1, event) -> this.handleRename(player, gang, gang.getLevel().hasFeature(LevelFeature.RENAMING))).build());
        }
        if (gang.isPermitted(player, GangPermission.VIEW_VAULT)) {
            viewer.addItem((gang.isVaultUnlocked() ? this.vaultIcon : this.vaultLockedIcon).copy().hideAllComponents().replacement(replacer -> replacer.replace(gang.replacePlaceholders()).replace("%amount%", (Object)String.valueOf(gang.getVault().countItems()))).toMenuItem().setSlots(new int[]{this.vaultSlot}).setHandler((viewer1, event) -> this.handleVault(player, gang)).build());
        }
        if (gang.isPermitted(player, GangPermission.VIEW_BANK)) {
            viewer.addItem(this.bankIcon.copy().hideAllComponents().replacement(replacer -> replacer.replace(gang.replacePlaceholders()).replace("%balance%", (Object)(gang.getBank().isEmpty() ? Lang.OTHER_BANK_BALANCE_EMPTY.text() : gang.getBank().formatBalances(Lang.OTHER_BANK_BALANCE_DELIMITER.text())))).toMenuItem().setSlots(new int[]{this.bankSlot}).setHandler((viewer1, event) -> this.handleBank(player, gang)).build());
        }
        if (gang.isOwner(player)) {
            viewer.addItem(this.disbandIcon.copy().toMenuItem().setSlots(new int[]{this.disbandSlot}).setHandler((viewer1, event) -> this.handleDisband(player, gang)).build());
        }
        if (GangLevels.count() > 1) {
            viewer.addItem(this.levelsIcon.copy().hideAllComponents().replacement(replacer -> replacer.replace(gang.replacePlaceholders())).toMenuItem().setSlots(new int[]{this.levelsSlot}).setHandler((viewer1, event) -> this.handleLevels(player, gang)).build());
        }
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    private void handleInvite(@NotNull Player player, @NotNull Gang gang, boolean allowed) {
        if (!allowed) {
            return;
        }
        GangDialogs.GANG_INVITE.ifPresent(dialog -> dialog.show(player, gang, () -> ((Player)player).closeInventory()));
    }

    private void handleRename(@NotNull Player player, @NotNull Gang gang, boolean allowed) {
        if (!allowed) {
            return;
        }
        GangDialogs.GANG_NAME.ifPresent(dialog -> dialog.show(player, gang, () -> this.flush(player)));
    }

    private void handleVault(@NotNull Player player, @NotNull Gang gang) {
        this.runNextTick(() -> this.manager.viewVault(player, gang));
    }

    private void handleBank(@NotNull Player player, @NotNull Gang gang) {
        this.manager.viewBank(player, gang, () -> this.flush(player));
    }

    private void handleLevels(@NotNull Player player, @NotNull Gang gang) {
        this.runNextTick(() -> this.manager.openLevelsMenu(player, gang));
    }

    private void handleFriendlyFire(@NotNull Player player, @NotNull Gang gang) {
        this.manager.toggleFriendlyFire(player, gang);
        this.runNextTick(() -> this.flush(player));
    }

    private void handleDisband(@NotNull Player player, @NotNull Gang gang) {
        GangDialogs.GANG_DISBAND.ifPresent(dialog -> dialog.show(player, gang, () -> {
            player.closeInventory();
            this.manager.disbandGang(player);
        }));
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        loader.addDefaultItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(45, 54).toArray()));
        this.memberSlots = (int[])ConfigValue.create((String)"Buttons.Member.Slots", (int[])new int[]{13, 20, 21, 22, 23, 24, 29, 30, 31, 32, 33}, (String[])new String[0]).read(config);
        this.memberSelfIcon = (NightItem)ConfigValue.create((String)"Buttons.Member.Self", (NightItem)NightItem.fromType((Material)Material.PLAYER_HEAD).setDisplayName(TagWrappers.SOFT_YELLOW.wrap("%member_name%") + " " + TagWrappers.DARK_GRAY.wrap("[" + TagWrappers.WHITE.wrap("You") + "]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("In Game: " + TagWrappers.SOFT_AQUA.wrap("%member_online_time%")), "", TagWrappers.SOFT_YELLOW.wrap("Info:"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Location: ") + TagWrappers.SOFT_BLUE.wrap("%player_world%") + " " + TagWrappers.DARK_GRAY.wrap("[%player_x%, %player_y%, %player_z%]"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Health: ") + TagWrappers.SOFT_RED.wrap("%player_health%"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Money: ") + TagWrappers.SOFT_GREEN.wrap("$%vault_eco_balance_formatted%"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("XP Level: ") + TagWrappers.SOFT_YELLOW.wrap("%player_level%")})), (String[])new String[0]).read(config);
        this.memberOnlineIcon = (NightItem)ConfigValue.create((String)"Buttons.Member.Online", (NightItem)NightItem.fromType((Material)Material.PLAYER_HEAD).setDisplayName(TagWrappers.SOFT_YELLOW.wrap("%member_name%") + " " + TagWrappers.DARK_GRAY.wrap("[%member_online%]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("In Game: " + TagWrappers.SOFT_AQUA.wrap("%member_online_time%")), "", TagWrappers.SOFT_YELLOW.wrap("Info:"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Location: ") + TagWrappers.SOFT_BLUE.wrap("%player_world%") + " " + TagWrappers.DARK_GRAY.wrap("[%player_x%, %player_y%, %player_z%]"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Health: ") + TagWrappers.SOFT_RED.wrap("%player_health%"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Money: ") + TagWrappers.SOFT_GREEN.wrap("$%vault_eco_balance_formatted%"), TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("XP Level: ") + TagWrappers.SOFT_YELLOW.wrap("%player_level%"), "", TagWrappers.SOFT_YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click for actions"))})), (String[])new String[0]).read(config);
        this.memberOfflineIcon = (NightItem)ConfigValue.create((String)"Buttons.Member.Offline", (NightItem)NightItem.fromType((Material)Material.PLAYER_HEAD).setDisplayName(TagWrappers.SOFT_YELLOW.wrap("%member_name%") + " " + TagWrappers.DARK_GRAY.wrap("[%member_online%]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Last Seen: " + TagWrappers.SOFT_PINK.wrap("%member_online_time%")), "", TagWrappers.SOFT_YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click for actions"))})), (String[])new String[0]).read(config);
        this.memberInviteIcon = (NightItem)ConfigValue.create((String)"Buttons.Member.Invite", (NightItem)NightItem.fromType((Material)Material.CYAN_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_AQUA.wrap("Invite Player")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Invite more players to your gang!"), "", TagWrappers.SOFT_AQUA.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to invite"))})), (String[])new String[0]).read(config);
        this.memberLockedIcon = (NightItem)ConfigValue.create((String)"Buttons.Member.Locked", (NightItem)NightItem.fromType((Material)Material.GRAY_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_YELLOW.wrap("Member Slot") + " " + TagWrappers.GRAY.wrap("(Locked)")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Upgrade " + TagWrappers.SOFT_YELLOW.wrap("gang level") + " to unlock!")})), (String[])new String[0]).read(config);
        this.memberEmptyIcon = (NightItem)ConfigValue.create((String)"Buttons.Member.Empty", (NightItem)NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_YELLOW.wrap("Member Slot")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("A vacant slot for new members.")})), (String[])new String[0]).read(config);
        this.friendlyFireSlot = (Integer)ConfigValue.create((String)"Buttons.FriendlyFire.Slot", (int)47, (String[])new String[0]).read(config);
        this.friendlyFireIcon = (NightItem)ConfigValue.create((String)"Buttons.FriendlyFire.Default", (NightItem)NightItem.fromType((Material)Material.NETHERITE_HELMET).setDisplayName(TagWrappers.ORANGE.wrap("Friendly Fire")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("State: ") + TagWrappers.ORANGE.wrap("%gang_friendly_fire%"), "", TagWrappers.GRAY.wrap("Controls whether gang members can"), TagWrappers.GRAY.wrap("damage each other."), "", TagWrappers.ORANGE.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to toggle"))})), (String[])new String[0]).read(config);
        this.disbandSlot = (Integer)ConfigValue.create((String)"Buttons.Disband.Slot", (int)49, (String[])new String[0]).read(config);
        this.disbandIcon = (NightItem)ConfigValue.create((String)"Buttons.Disband.Default", (NightItem)NightItem.fromType((Material)Material.BARRIER).setDisplayName(TagWrappers.SOFT_RED.wrap("Disband")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Disband the gang."), "", TagWrappers.SOFT_RED.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to disband"))})), (String[])new String[0]).read(config);
        this.nameSlot = (Integer)ConfigValue.create((String)"Buttons.Name.Slot", (int)51, (String[])new String[0]).read(config);
        this.nameIcon = (NightItem)ConfigValue.create((String)"Buttons.Name.Default", (NightItem)NightItem.fromType((Material)Material.FILLED_MAP).setDisplayName(TagWrappers.SOFT_YELLOW.wrap("Gang Name")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.SOFT_YELLOW.wrap("%gang_name%"), "", TagWrappers.SOFT_YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to change"))})), (String[])new String[0]).read(config);
        this.nameLockedIcon = (NightItem)ConfigValue.create((String)"Buttons.Name.Locked", (NightItem)NightItem.fromType((Material)Material.FILLED_MAP).setDisplayName(TagWrappers.GRAY.wrap("Gang Name") + " " + TagWrappers.RED.wrap("[Locked]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Upgrade " + TagWrappers.RED.wrap("gang level") + " to unlock!")})), (String[])new String[0]).read(config);
        this.vaultSlot = (Integer)ConfigValue.create((String)"Buttons.Vault.Slot", (int)52, (String[])new String[0]).read(config);
        this.vaultIcon = (NightItem)ConfigValue.create((String)"Buttons.Vault.Default", (NightItem)NightItem.fromType((Material)Material.ENDER_CHEST).setDisplayName(TagWrappers.SOFT_PURPLE.wrap("Gang's Vault")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Vault Items: " + TagWrappers.SOFT_PURPLE.wrap("%amount%") + "/" + TagWrappers.SOFT_PURPLE.wrap("%gang_vault_size%")), "", TagWrappers.SOFT_PURPLE.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to open"))})), (String[])new String[0]).read(config);
        this.vaultLockedIcon = (NightItem)ConfigValue.create((String)"Buttons.Vault.Locked", (NightItem)NightItem.fromType((Material)Material.ENDER_CHEST).setDisplayName(TagWrappers.GRAY.wrap("Gang's Vault") + " " + TagWrappers.RED.wrap("[Locked]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Upgrade " + TagWrappers.RED.wrap("gang level") + " to unlock!")})), (String[])new String[0]).read(config);
        this.bankSlot = (Integer)ConfigValue.create((String)"Buttons.Bank.Slot", (int)46, (String[])new String[0]).read(config);
        this.bankIcon = (NightItem)ConfigValue.create((String)"Buttons.Bank.Default", (NightItem)NightItem.fromType((Material)Material.EMERALD).setDisplayName(TagWrappers.SOFT_GREEN.wrap("Gang's Bank")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Balance: " + TagWrappers.SOFT_GREEN.wrap("%balance%")), "", TagWrappers.SOFT_GREEN.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to open"))})), (String[])new String[0]).read(config);
        this.levelsSlot = (Integer)ConfigValue.create((String)"Buttons.Levels.Slot", (int)8, (String[])new String[0]).read(config);
        this.levelsIcon = (NightItem)ConfigValue.create((String)"Buttons.Levels.Default", (NightItem)NightItem.fromType((Material)Material.FIREWORK_ROCKET).setDisplayName(TagWrappers.SOFT_ORANGE.wrap("Gang Levels")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + " " + TagWrappers.GRAY.wrap("Current: " + TagWrappers.SOFT_ORANGE.wrap("%gang_level_name%")), "", TagWrappers.SOFT_ORANGE.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to open"))})), (String[])new String[0]).read(config);
    }
}

