/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.menu;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.dialog.GangDialogs;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.excellentgangs.registry.GangLevels;
import su.nightexpress.excellentgangs.util.GangUtils;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class LevelsMenu
extends LinkedMenu<GangsPlugin, Gang>
implements ConfigBased,
LangContainer {
    private static final IconLocale LEVEL_INFO = LangEntry.iconBuilder((String)"UI.Levels.LevelInfo").rawName(TagWrappers.YELLOW.wrap("%level_name%")).rawLore(new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + TagWrappers.GRAY.wrap(" Members Limit ") + TagWrappers.YELLOW.wrap("%level_max_members%"), TagWrappers.DARK_GRAY.wrap("\u00bb") + TagWrappers.GRAY.wrap(" Vault Size ") + TagWrappers.YELLOW.wrap("%level_vault_size%"), " ", TagWrappers.YELLOW.and((TagWrapper)TagWrappers.BOLD).wrap("FEATURES:"), "%features%", " ", TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap("REQUIREMENTS:") + " " + TagWrappers.WHITE.wrap("%requirements%")}).build();
    private final GangManager manager;
    private final Map<Integer, int[]> slotsByLevelCount;
    private NightItem upgradeAvailIcon;
    private NightItem upgradeLockedIcon;
    private int upgradeSlot;

    public LevelsMenu(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, TagWrappers.BLACK.wrap("Gang Levels"));
        ((GangsPlugin)this.plugin).injectLang(this);
        this.manager = manager;
        this.slotsByLevelCount = new HashMap<Integer, int[]>();
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        Gang gang = (Gang)this.getLink(player);
        GangLevel gangLevel = gang.getLevel();
        GangLevel nextLevel = GangLevels.getNext(gangLevel);
        List<GangLevel> levels = GangLevels.getLevels().stream().sorted(Comparator.comparingInt(GangLevel::getValue)).toList();
        int levelCount = levels.size();
        int[] levelSlots = this.slotsByLevelCount.getOrDefault(levelCount, new int[0]);
        for (int index = 0; index < levels.size() && index < levelSlots.length; ++index) {
            int skillSlot = levelSlots[index];
            GangLevel level = levels.get(index);
            viewer.addItem(level.getIcon().hideAllComponents().localized(LEVEL_INFO).replacement(replacer -> replacer.replace("%features%", () -> GangUtils.formatFeatures(level)).replace("%requirements%", () -> GangUtils.formatRequirements(level)).replace(level.replacePlaceholders())).toMenuItem().setSlots(new int[]{skillSlot}).build());
        }
        if (nextLevel != null) {
            boolean canUpgrade = nextLevel.isMetRequirements(gang);
            viewer.addItem((canUpgrade ? this.upgradeAvailIcon : this.upgradeLockedIcon).copy().replacement(replacer -> replacer.replace(nextLevel.replacePlaceholders())).hideAllComponents().toMenuItem().setSlots(new int[]{this.upgradeSlot}).setHandler((viewer1, event) -> this.handleUpgrade(player, gang, canUpgrade)).build());
        }
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    private void handleUpgrade(@NotNull Player player, @NotNull Gang gang, boolean allowed) {
        if (!allowed) {
            return;
        }
        GangDialogs.GANG_UPGRADE.ifPresent(dialog -> dialog.show(player, gang, () -> {
            this.manager.upgradeLevel(player, gang);
            this.flush(player);
        }));
    }

    private void handleReturn(@NotNull MenuViewer viewer, @NotNull InventoryClickEvent event) {
        this.runNextTick(() -> this.manager.openGangMenu(viewer.getPlayer()));
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        loader.addDefaultItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 36, 37, 38, 39, 40, 41, 42, 43, 44}));
        loader.addDefaultItem(MenuItem.background((Material)Material.GRAY_STAINED_GLASS_PANE, (int[])IntStream.range(9, 36).toArray()));
        loader.addDefaultItem(MenuItem.buildReturn((Menu)this, (int)40, this::handleReturn));
        for (int count = 0; count < 10; ++count) {
            int amount = count + 1;
            int[] defSlots = LevelsMenu.getDefaultSlots(amount);
            int[] skillSlots = (int[])ConfigValue.create((String)("Level.SlotsByCount." + amount), (int[])defSlots, (String[])new String[0]).read(config);
            this.slotsByLevelCount.put(amount, skillSlots);
        }
        this.upgradeSlot = (Integer)ConfigValue.create((String)"Level.Upgrade.Slot", (int)4, (String[])new String[0]).read(config);
        this.upgradeAvailIcon = (NightItem)ConfigValue.create((String)"Level.Upgrade.Available", (NightItem)NightItem.fromType((Material)Material.LIME_STAINED_GLASS_PANE).setDisplayName(TagWrappers.GREEN.wrap("Upgrade Level")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Your gang is met all the"), TagWrappers.GRAY.wrap("requirements for the " + TagWrappers.GREEN.wrap("%level_name%") + "!"), "", TagWrappers.GREEN.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to upgrade!"))})), (String[])new String[0]).read(config);
        this.upgradeLockedIcon = (NightItem)ConfigValue.create((String)"Level.Upgrade.Locked", (NightItem)NightItem.fromType((Material)Material.RED_STAINED_GLASS_PANE).setDisplayName(TagWrappers.RED.wrap("Upgrade Level")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Your gang does not met the"), TagWrappers.GRAY.wrap("requirements for the " + TagWrappers.RED.wrap("%level_name%") + ".")})), (String[])new String[0]).read(config);
    }

    private static int[] getDefaultSlots(int count) {
        int[] nArray;
        switch (count) {
            case 1: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 22;
                break;
            }
            case 2: {
                int[] nArray3 = new int[2];
                nArray3[0] = 21;
                nArray = nArray3;
                nArray3[1] = 23;
                break;
            }
            case 3: {
                int[] nArray4 = new int[3];
                nArray4[0] = 21;
                nArray4[1] = 22;
                nArray = nArray4;
                nArray4[2] = 23;
                break;
            }
            case 4: {
                int[] nArray5 = new int[4];
                nArray5[0] = 21;
                nArray5[1] = 22;
                nArray5[2] = 24;
                nArray = nArray5;
                nArray5[3] = 25;
                break;
            }
            case 5: {
                int[] nArray6 = new int[5];
                nArray6[0] = 20;
                nArray6[1] = 21;
                nArray6[2] = 22;
                nArray6[3] = 23;
                nArray = nArray6;
                nArray6[4] = 24;
                break;
            }
            case 6: {
                int[] nArray7 = new int[6];
                nArray7[0] = 20;
                nArray7[1] = 21;
                nArray7[2] = 22;
                nArray7[3] = 23;
                nArray7[4] = 24;
                nArray = nArray7;
                nArray7[5] = 31;
                break;
            }
            case 7: {
                int[] nArray8 = new int[7];
                nArray8[0] = 20;
                nArray8[1] = 21;
                nArray8[2] = 22;
                nArray8[3] = 23;
                nArray8[4] = 24;
                nArray8[5] = 30;
                nArray = nArray8;
                nArray8[6] = 32;
                break;
            }
            case 8: {
                int[] nArray9 = new int[8];
                nArray9[0] = 20;
                nArray9[1] = 21;
                nArray9[2] = 22;
                nArray9[3] = 23;
                nArray9[4] = 24;
                nArray9[5] = 30;
                nArray9[6] = 31;
                nArray = nArray9;
                nArray9[7] = 32;
                break;
            }
            case 9: {
                int[] nArray10 = new int[9];
                nArray10[0] = 20;
                nArray10[1] = 21;
                nArray10[2] = 22;
                nArray10[3] = 23;
                nArray10[4] = 24;
                nArray10[5] = 29;
                nArray10[6] = 30;
                nArray10[7] = 32;
                nArray = nArray10;
                nArray10[8] = 33;
                break;
            }
            case 10: {
                int[] nArray11 = new int[10];
                nArray11[0] = 20;
                nArray11[1] = 21;
                nArray11[2] = 22;
                nArray11[3] = 23;
                nArray11[4] = 24;
                nArray11[5] = 29;
                nArray11[6] = 30;
                nArray11[7] = 31;
                nArray11[8] = 32;
                nArray = nArray11;
                nArray11[9] = 33;
                break;
            }
            default: {
                nArray = new int[]{};
            }
        }
        return nArray;
    }
}

