/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.menu;

import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class MemberInventoryMenu
extends LinkedMenu<GangsPlugin, GangMember>
implements ConfigBased {
    private final GangManager manager;
    private int[] inventorySlots;
    private NightItem helmetPlaceholder;
    private int helmetSlot;
    private NightItem chestPlaceholder;
    private int chestSlot;
    private NightItem legsPlaceholder;
    private int legsSlot;
    private NightItem feetPlaceholder;
    private int feetSlot;
    private NightItem offhandPlaceholder;
    private int offhandSlot;

    public MemberInventoryMenu(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X6, TagWrappers.BLACK.wrap("%member_name%'s Inventory"));
        this.manager = manager;
    }

    @NotNull
    protected String getTitle(@NotNull MenuViewer viewer) {
        return (String)((GangMember)this.getLink(viewer)).replacePlaceholders().apply(super.getTitle(viewer));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        viewer.addItem(this.helmetPlaceholder.copy().toMenuItem().setPriority(1).setSlots(new int[]{this.helmetSlot}).build());
        viewer.addItem(this.chestPlaceholder.copy().toMenuItem().setPriority(1).setSlots(new int[]{this.chestSlot}).build());
        viewer.addItem(this.legsPlaceholder.copy().toMenuItem().setPriority(1).setSlots(new int[]{this.legsSlot}).build());
        viewer.addItem(this.feetPlaceholder.copy().toMenuItem().setPriority(1).setSlots(new int[]{this.feetSlot}).build());
        viewer.addItem(this.offhandPlaceholder.copy().toMenuItem().setPriority(1).setSlots(new int[]{this.offhandSlot}).build());
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
        Player player = viewer.getPlayer();
        GangMember member = (GangMember)this.getLink(player);
        Player other = member.getPlayer();
        if (other == null) {
            return;
        }
        PlayerInventory playerInventory = other.getInventory();
        for (int index = 0; index < this.inventorySlots.length && index < playerInventory.getSize(); ++index) {
            int slot = this.inventorySlots[index];
            if (slot >= inventory.getSize()) continue;
            ItemStack itemStack = playerInventory.getItem(index);
            inventory.setItem(slot, itemStack);
        }
        this.setEquipmentItem(playerInventory, inventory, EquipmentSlot.HEAD, this.helmetSlot);
        this.setEquipmentItem(playerInventory, inventory, EquipmentSlot.CHEST, this.chestSlot);
        this.setEquipmentItem(playerInventory, inventory, EquipmentSlot.LEGS, this.legsSlot);
        this.setEquipmentItem(playerInventory, inventory, EquipmentSlot.FEET, this.feetSlot);
        this.setEquipmentItem(playerInventory, inventory, EquipmentSlot.OFF_HAND, this.offhandSlot);
    }

    private void setEquipmentItem(@NotNull PlayerInventory playerInventory, @NotNull Inventory inventory, @NotNull EquipmentSlot equipmentSlot, int slot) {
        ItemStack itemStack = playerInventory.getItem(equipmentSlot);
        if (itemStack.getType().isAir()) {
            return;
        }
        inventory.setItem(slot, itemStack);
    }

    private void handleReturn(@NotNull MenuViewer viewer, @NotNull InventoryClickEvent event) {
        this.runNextTick(() -> this.manager.openMemberMenu(viewer.getPlayer(), (GangMember)this.getLink(viewer)));
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        loader.addDefaultItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(36, 54).toArray()));
        loader.addDefaultItem(MenuItem.buildReturn((Menu)this, (int)49, this::handleReturn));
        this.inventorySlots = (int[])ConfigValue.create((String)"Inventory.ItemSlots", (int[])IntStream.range(0, 36).toArray(), (String[])new String[0]).read(config);
        this.helmetSlot = (Integer)ConfigValue.create((String)"Inventory.Helmet.Slot", (int)38, (String[])new String[0]).read(config);
        this.helmetPlaceholder = (NightItem)ConfigValue.create((String)"Inventory.Helmet.Placeholder", (NightItem)NightItem.fromType((Material)Material.RED_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_RED.wrap("No Helmet")), (String[])new String[0]).read(config);
        this.chestSlot = (Integer)ConfigValue.create((String)"Inventory.Chest.Slot", (int)39, (String[])new String[0]).read(config);
        this.chestPlaceholder = (NightItem)ConfigValue.create((String)"Inventory.Chest.Placeholder", (NightItem)NightItem.fromType((Material)Material.RED_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_RED.wrap("No Chestplate")), (String[])new String[0]).read(config);
        this.legsSlot = (Integer)ConfigValue.create((String)"Inventory.Legs.Slot", (int)40, (String[])new String[0]).read(config);
        this.legsPlaceholder = (NightItem)ConfigValue.create((String)"Inventory.Legs.Placeholder", (NightItem)NightItem.fromType((Material)Material.RED_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_RED.wrap("No Leggings")), (String[])new String[0]).read(config);
        this.feetSlot = (Integer)ConfigValue.create((String)"Inventory.Feet.Slot", (int)41, (String[])new String[0]).read(config);
        this.feetPlaceholder = (NightItem)ConfigValue.create((String)"Inventory.Feet.Placeholder", (NightItem)NightItem.fromType((Material)Material.RED_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_RED.wrap("No Boots")), (String[])new String[0]).read(config);
        this.offhandSlot = (Integer)ConfigValue.create((String)"Inventory.Offhand.Slot", (int)42, (String[])new String[0]).read(config);
        this.offhandPlaceholder = (NightItem)ConfigValue.create((String)"Inventory.Offhand.Placeholder", (NightItem)NightItem.fromType((Material)Material.RED_STAINED_GLASS_PANE).setDisplayName(TagWrappers.SOFT_RED.wrap("No Offhand Item")), (String[])new String[0]).read(config);
    }
}

