/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.menu;

import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.dialog.GangDialogs;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.gang.GangMember;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.gang.rank.GangRank;
import su.nightexpress.excellentgangs.registry.GangRanks;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class MemberMenu
extends LinkedMenu<GangsPlugin, GangMember>
implements ConfigBased {
    private final GangManager manager;
    private NightItem tpIcon;
    private NightItem tpOfflineIcon;
    private NightItem tpDeniedIcon;
    private int tpSlot;
    private NightItem invIcon;
    private NightItem invOfflineIcon;
    private NightItem invDeniedIcon;
    private int invSlot;
    private NightItem transferIcon;
    private int transferSlot;
    private NightItem kickIcon;
    private int kickSlot;
    private NightItem demoteIcon;
    private NightItem demoteMinIcon;
    private int demoteSlot;
    private NightItem promoteIcon;
    private NightItem promoteMaxIcon;
    private int promoteSlot;

    public MemberMenu(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, TagWrappers.BLACK.wrap("Gang Member: %member_name%"));
        this.manager = manager;
    }

    @NotNull
    protected String getTitle(@NotNull MenuViewer viewer) {
        return (String)((GangMember)this.getLink(viewer)).replacePlaceholders().apply(super.getTitle(viewer));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player moderator = viewer.getPlayer();
        GangMember member = (GangMember)this.getLink(moderator);
        GangRank rank = member.getRank();
        Gang gang = member.getGang();
        UnaryOperator<String> memberReplacer = member.replacePlaceholders();
        GangMember moderMember = gang.getMember(moderator);
        if (moderMember == null) {
            return;
        }
        GangRank moderRank = moderMember.getRank();
        boolean isOnline = member.isOnline();
        boolean canTeleport = gang.isPermitted(moderator, GangPermission.TELEPORT_TO_MEMBER);
        boolean canViewInv = gang.isPermitted(moderator, GangPermission.VIEW_MEMBER_INVENTORY);
        viewer.addItem((!canTeleport ? this.tpDeniedIcon : (isOnline ? this.tpIcon : this.tpOfflineIcon)).copy().replacement(replacer -> replacer.replace(memberReplacer)).toMenuItem().setSlots(new int[]{this.tpSlot}).setHandler((viewer1, event) -> this.handleTeleport(moderator, member, canTeleport && isOnline)).build());
        viewer.addItem((!canViewInv ? this.invDeniedIcon : (isOnline ? this.invIcon : this.invOfflineIcon)).copy().replacement(replacer -> replacer.replace(memberReplacer)).toMenuItem().setSlots(new int[]{this.invSlot}).setHandler((viewer1, event) -> this.handleInventory(moderator, gang, member, canViewInv && isOnline)).build());
        if (gang.isOwner(moderator)) {
            viewer.addItem(this.transferIcon.copy().replacement(replacer -> replacer.replace(memberReplacer)).toMenuItem().setSlots(new int[]{this.transferSlot}).setHandler((viewer1, event) -> this.handleTransfer(moderator, member)).build());
        }
        if (gang.isPermitted(moderator, GangPermission.KICK_MEMBER)) {
            viewer.addItem(this.kickIcon.copy().replacement(replacer -> replacer.replace(memberReplacer)).toMenuItem().setSlots(new int[]{this.kickSlot}).setHandler((viewer1, event) -> this.handleKick(moderator, member)).build());
        }
        if (gang.isPermitted(moderator, GangPermission.PROMOTE_MEMBER)) {
            GangRank nextRank = GangRanks.getNextRank(rank);
            boolean canNext = nextRank != null && rank.isUnder(nextRank) && moderRank.isAbove(nextRank);
            viewer.addItem((canNext ? this.promoteIcon : this.promoteMaxIcon).copy().replacement(replacer -> replacer.replace(memberReplacer).replace("%to%", () -> nextRank == null ? CoreLang.OTHER_NONE.text() : nextRank.getName())).toMenuItem().setSlots(new int[]{this.promoteSlot}).setHandler((viewer1, event) -> this.handlePromote(moderator, member, canNext)).build());
        }
        if (gang.isPermitted(moderator, GangPermission.DEMOTE_MEMBER)) {
            GangRank backRank = GangRanks.getPreviousRank(rank);
            boolean canBack = backRank != null && rank.isAbove(backRank) && moderRank.isAbove(rank);
            viewer.addItem((canBack ? this.demoteIcon : this.demoteMinIcon).copy().replacement(replacer -> replacer.replace(memberReplacer).replace("%to%", () -> backRank == null ? CoreLang.OTHER_NONE.text() : backRank.getName())).toMenuItem().setSlots(new int[]{this.demoteSlot}).setHandler((viewer1, event) -> this.handleDemote(moderator, member, canBack)).build());
        }
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    private void handleTeleport(@NotNull Player moderator, @NotNull GangMember member, boolean enabled) {
        if (!enabled) {
            return;
        }
        this.manager.teleportToMember(moderator, member);
    }

    private void handleInventory(@NotNull Player moderator, @NotNull Gang gang, @NotNull GangMember member, boolean enabled) {
        if (!enabled) {
            return;
        }
        this.manager.viewMemberInventory(moderator, gang, member);
    }

    private void handleTransfer(@NotNull Player moderator, @NotNull GangMember member) {
        GangDialogs.GANG_TRANSFER.ifPresent(dialog -> dialog.show(moderator, member, () -> {
            moderator.closeInventory();
            this.manager.transferGang(moderator, member);
        }));
    }

    private void handleKick(@NotNull Player moderator, @NotNull GangMember member) {
        GangDialogs.GANG_KICK.ifPresent(dialog -> dialog.show(moderator, member, () -> {
            this.manager.kickMember(moderator, member);
            this.manager.openGangMenu(moderator);
        }));
    }

    private void handlePromote(@NotNull Player moderator, @NotNull GangMember member, boolean canNext) {
        if (!canNext) {
            return;
        }
        GangDialogs.GANG_PROMOTE.ifPresent(dialog -> dialog.show(moderator, member, () -> {
            this.manager.promoteMember(moderator, member);
            this.flush(moderator);
        }));
    }

    private void handleDemote(@NotNull Player moderator, @NotNull GangMember member, boolean canBack) {
        if (!canBack) {
            return;
        }
        GangDialogs.GANG_DEMOTE.ifPresent(dialog -> dialog.show(moderator, member, () -> {
            this.manager.demoteMember(moderator, member);
            this.flush(moderator);
        }));
    }

    private void handleReturn(@NotNull MenuViewer viewer, @NotNull InventoryClickEvent event) {
        this.runNextTick(() -> this.manager.openGangMenu(viewer.getPlayer()));
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        loader.addDefaultItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 36, 37, 38, 39, 40, 41, 42, 43, 44}));
        loader.addDefaultItem(MenuItem.buildReturn((Menu)this, (int)40, this::handleReturn));
        this.tpSlot = (Integer)ConfigValue.create((String)"Buttons.Teleport.Slot", (int)21, (String[])new String[0]).read(config);
        this.tpIcon = (NightItem)ConfigValue.create((String)"Buttons.Teleport.Default", (NightItem)NightItem.fromType((Material)Material.ACACIA_BOAT).hideAllComponents().setDisplayName(TagWrappers.GOLD.wrap("Teleport")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Quickly teleports you to " + TagWrappers.GOLD.wrap("%member_name%") + "."), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to teleport"))})), (String[])new String[0]).read(config);
        this.tpDeniedIcon = (NightItem)ConfigValue.create((String)"Buttons.Teleport.NoPermission", (NightItem)NightItem.fromType((Material)Material.DARK_OAK_BOAT).hideAllComponents().setDisplayName(TagWrappers.GOLD.wrap("Teleport") + " " + TagWrappers.RED.wrap("[No Access]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("You can't teleport to gang's members.")})), (String[])new String[0]).read(config);
        this.tpOfflineIcon = (NightItem)ConfigValue.create((String)"Buttons.Teleport.Offline", (NightItem)NightItem.fromType((Material)Material.PALE_OAK_BOAT).hideAllComponents().setDisplayName(TagWrappers.WHITE.wrap("Teleport") + " " + TagWrappers.RED.wrap("[Offline]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Offline teleports are not supported.")})), (String[])new String[0]).read(config);
        this.invSlot = (Integer)ConfigValue.create((String)"Buttons.Inventory.Slot", (int)23, (String[])new String[0]).read(config);
        this.invIcon = (NightItem)ConfigValue.create((String)"Buttons.Inventory.Default", (NightItem)NightItem.fromType((Material)Material.CHEST).hideAllComponents().setDisplayName(TagWrappers.SOFT_AQUA.wrap("View Inventory")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Opens " + TagWrappers.SOFT_AQUA.wrap("%member_name%") + "'s inventory."), "", TagWrappers.SOFT_AQUA.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to view"))})), (String[])new String[0]).read(config);
        this.invDeniedIcon = (NightItem)ConfigValue.create((String)"Buttons.Inventory.NoPermission", (NightItem)NightItem.fromType((Material)Material.CHEST).hideAllComponents().setDisplayName(TagWrappers.SOFT_AQUA.wrap("View Inventory") + " " + TagWrappers.RED.wrap("[No Access]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("You can't view gang member's inventories.")})), (String[])new String[0]).read(config);
        this.invOfflineIcon = (NightItem)ConfigValue.create((String)"Buttons.Inventory.Offline", (NightItem)NightItem.fromType((Material)Material.CHEST).hideAllComponents().setDisplayName(TagWrappers.WHITE.wrap("View Inventory") + " " + TagWrappers.RED.wrap("[Offline]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Offline inventories can not be seen.")})), (String[])new String[0]).read(config);
        this.transferSlot = (Integer)ConfigValue.create((String)"Buttons.TransferLeadership.Slot", (int)0, (String[])new String[0]).read(config);
        this.transferIcon = (NightItem)ConfigValue.create((String)"Buttons.TransferLeadership.Icon", (NightItem)NightItem.fromType((Material)Material.RED_BANNER).setDisplayName(TagWrappers.SOFT_RED.wrap("Transfer Leadership")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Transfer the gang leadership"), TagWrappers.GRAY.wrap("to " + TagWrappers.SOFT_RED.wrap("%member_name%")), "", TagWrappers.SOFT_RED.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to transfer"))})), (String[])new String[0]).read(config);
        this.kickSlot = (Integer)ConfigValue.create((String)"Buttons.Kick.Slot", (int)8, (String[])new String[0]).read(config);
        this.kickIcon = (NightItem)ConfigValue.create((String)"Buttons.Kick.Icon", (NightItem)NightItem.fromType((Material)Material.BARRIER).setDisplayName(TagWrappers.SOFT_RED.wrap("Kick")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Kicks " + TagWrappers.SOFT_RED.wrap("%member_name%") + " from the gang."), "", TagWrappers.SOFT_RED.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to kick"))})), (String[])new String[0]).read(config);
        this.demoteSlot = (Integer)ConfigValue.create((String)"Buttons.Demote.Slot", (int)3, (String[])new String[0]).read(config);
        this.demoteIcon = (NightItem)ConfigValue.create((String)"Buttons.Demote.Default", (NightItem)NightItem.fromType((Material)Material.MELON_SLICE).setDisplayName(TagWrappers.SOFT_RED.wrap("Demote")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Demote " + TagWrappers.SOFT_RED.wrap("%member_name%") + ": " + TagWrappers.WHITE.wrap("%member_rank%") + " \u2192 " + TagWrappers.WHITE.wrap("%to%")), "", TagWrappers.SOFT_RED.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to demote"))})), (String[])new String[0]).read(config);
        this.demoteMinIcon = (NightItem)ConfigValue.create((String)"Buttons.Demote.Min", (NightItem)NightItem.fromType((Material)Material.GRAY_DYE).setDisplayName(TagWrappers.WHITE.wrap("Demote") + " " + TagWrappers.GRAY.wrap("(Lowest)")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + TagWrappers.GRAY.wrap(" Rank: ") + TagWrappers.WHITE.wrap("%member_rank%"), "", TagWrappers.GRAY.wrap("You can't demote " + TagWrappers.WHITE.wrap("%member_name%") + " further.")})), (String[])new String[0]).read(config);
        this.promoteSlot = (Integer)ConfigValue.create((String)"Buttons.Promote.Slot", (int)5, (String[])new String[0]).read(config);
        this.promoteIcon = (NightItem)ConfigValue.create((String)"Buttons.Promote.Default", (NightItem)NightItem.fromType((Material)Material.GLISTERING_MELON_SLICE).setDisplayName(TagWrappers.YELLOW.wrap("Promote")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Promote " + TagWrappers.YELLOW.wrap("%member_name%") + ": " + TagWrappers.WHITE.wrap("%member_rank%") + " \u2192 " + TagWrappers.WHITE.wrap("%to%")), "", TagWrappers.YELLOW.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to promote"))})), (String[])new String[0]).read(config);
        this.promoteMaxIcon = (NightItem)ConfigValue.create((String)"Buttons.Promote.Max", (NightItem)NightItem.fromType((Material)Material.GRAY_DYE).setDisplayName(TagWrappers.WHITE.wrap("Promote") + " " + TagWrappers.GRAY.wrap("(Max.)")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb") + TagWrappers.GRAY.wrap(" Rank: ") + TagWrappers.WHITE.wrap("%member_rank%"), "", TagWrappers.GRAY.wrap("You can't promote " + TagWrappers.WHITE.wrap("%member_name%") + " further.")})), (String[])new String[0]).read(config);
    }
}

