/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.menu;

import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.gang.GangManager;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.gang.vault.GangVault;
import su.nightexpress.excellentgangs.registry.GangLevels;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class VaultMenu
extends LinkedMenu<GangsPlugin, GangVault>
implements ConfigBased {
    private final GangManager manager;
    private NightItem lockedSlotIcon;
    private NightItem backgroundSlotIcon;
    private int[] itemSlots;

    public VaultMenu(@NotNull GangsPlugin plugin, @NotNull GangManager manager) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X6, TagWrappers.BLACK.wrap("Gang's Vault"));
        this.manager = manager;
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        GangVault vault = (GangVault)this.getLink(player);
        Gang gang = this.manager.getGangById(vault.getGangId());
        if (gang == null) {
            return;
        }
        GangLevel level = gang.getLevel();
        int vaultSize = level.getVaultSize();
        int bestVaultSize = GangLevels.getLatest().getVaultSize();
        Inventory inventory = view.getTopInventory();
        int itemsPerPage = this.itemSlots.length;
        int pages = (int)Math.ceil((double)vaultSize / (double)itemsPerPage);
        viewer.setPages(pages);
        viewer.setPage(Math.min(viewer.getPage(), viewer.getPages()));
        int page = viewer.getPage();
        int startIndex = (page - 1) * itemsPerPage;
        for (int slotIndex = 0; slotIndex < itemsPerPage; ++slotIndex) {
            int invSlot = this.itemSlots[slotIndex];
            int lockIndex = startIndex + slotIndex;
            if (lockIndex < vaultSize) continue;
            if (lockIndex < bestVaultSize) {
                inventory.setItem(invSlot, this.lockedSlotIcon.replacement(replacer -> replacer.replace("%index%", (Object)String.valueOf(lockIndex + 1))).getItemStack());
                continue;
            }
            inventory.setItem(invSlot, this.backgroundSlotIcon.getItemStack());
        }
        vault.getItems().forEach((itemIndex, itemStack) -> {
            if (itemIndex < startIndex) {
                return;
            }
            int slotIndex = itemIndex - startIndex;
            if (slotIndex < 0 || slotIndex >= this.itemSlots.length) {
                return;
            }
            int invSlot = this.itemSlots[slotIndex];
            inventory.setItem(invSlot, itemStack);
        });
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onDrag(@NotNull MenuViewer viewer, @NotNull InventoryDragEvent event) {
        super.onDrag(viewer, event);
        Player player = viewer.getPlayer();
        Inventory inventory = event.getInventory();
        GangVault vault = (GangVault)this.getLink(player);
        Gang gang = this.manager.getGangById(vault.getGangId());
        if (gang == null || !gang.isPermitted(player, GangPermission.USE_VAULT)) {
            return;
        }
        if (event.getRawSlots().stream().anyMatch(clickedSlot -> {
            if (clickedSlot >= inventory.getSize()) {
                return false;
            }
            int slotIndex = Lists.indexOf((int[])this.itemSlots, (int)clickedSlot);
            return slotIndex < 0;
        })) {
            return;
        }
        event.setCancelled(false);
        this.runNextTick(() -> this.updateVaultItems(player, inventory, viewer.getPage()));
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        int page = viewer.getPage();
        Player player = viewer.getPlayer();
        Inventory inventory = event.getInventory();
        GangVault vault = (GangVault)this.getLink(player);
        Gang gang = this.manager.getGangById(vault.getGangId());
        if (gang == null || !gang.isPermitted(player, GangPermission.USE_VAULT)) {
            return;
        }
        if (result.isInventory()) {
            event.setCancelled(false);
            if (event.isShiftClick()) {
                this.runNextTick(() -> this.updateVaultItems(player, inventory, page));
            }
            return;
        }
        int clickedSlot = result.getSlot();
        int slotIndex = Lists.indexOf((int[])this.itemSlots, (int)clickedSlot);
        if (slotIndex < 0) {
            return;
        }
        int itemsPerPage = this.itemSlots.length;
        int index = (page - 1) * itemsPerPage + slotIndex;
        int vaultSize = gang.getVaultSize();
        if (index < vaultSize) {
            event.setCancelled(false);
            this.runNextTick(() -> this.updateVaultItems(player, inventory, page));
        }
    }

    private void updateVaultItems(@NotNull Player player, @NotNull Inventory inventory, int page) {
        int index;
        GangVault vault = (GangVault)this.getLink(player);
        Gang gang = this.manager.getGangById(vault.getGangId());
        if (gang == null || !gang.isPermitted(player, GangPermission.USE_VAULT)) {
            return;
        }
        int itemsPerPage = this.itemSlots.length;
        int startIndex = (page - 1) * itemsPerPage;
        int vaultSize = gang.getVaultSize();
        for (int slotIndex = 0; slotIndex < itemsPerPage && (index = startIndex + slotIndex) < vaultSize; ++slotIndex) {
            int invSlot = this.itemSlots[slotIndex];
            ItemStack afterStack = inventory.getItem(invSlot);
            vault.setItem(index, afterStack);
        }
        gang.markDirty();
    }

    public void onClose(@NotNull MenuViewer viewer, @NotNull InventoryCloseEvent event) {
        Player player = viewer.getPlayer();
        GangVault vault = (GangVault)this.getLink(player);
        vault.setInUse(false);
        super.onClose(viewer, event);
    }

    private void handleReturn(@NotNull MenuViewer viewer, @NotNull InventoryClickEvent event) {
        Player player = viewer.getPlayer();
        this.runNextTick(() -> this.manager.openGangMenu(player));
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        this.itemSlots = (int[])ConfigValue.create((String)"Item.Slots", (int[])IntStream.range(0, 45).toArray(), (String[])new String[0]).read(config);
        this.backgroundSlotIcon = (NightItem)ConfigValue.create((String)"Item.BackgroundSlot", (NightItem)NightItem.fromType((Material)Material.GRAY_STAINED_GLASS_PANE).setHideTooltip(true), (String[])new String[0]).read(config);
        this.lockedSlotIcon = (NightItem)ConfigValue.create((String)"Item.LockedSlot", (NightItem)NightItem.fromType((Material)Material.RED_STAINED_GLASS_PANE).hideAllComponents().setDisplayName(TagWrappers.GRAY.wrap("Vault Slot #%index%") + " " + TagWrappers.RED.wrap("[Locked]")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Upgrade " + TagWrappers.RED.wrap("gang's level") + " to unlock more slots!")})), (String[])new String[0]).read(config);
        loader.addDefaultItem(MenuItem.buildReturn((Menu)this, (int)49, this::handleReturn));
        loader.addDefaultItem(MenuItem.buildNextPage((Menu)this, (int)53));
        loader.addDefaultItem(MenuItem.buildPreviousPage((Menu)this, (int)45));
        loader.addDefaultItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(45, 54).toArray()));
    }
}

