/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.rank;

import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.StringUtil;

public class GangRank
implements Writeable {
    private final String id;
    private final String name;
    private final int priority;
    private final Set<GangPermission> permissions;

    public GangRank(@NotNull String id, @NotNull String name, int priority, @NotNull Set<GangPermission> permissions) {
        this.id = id;
        this.name = name;
        this.priority = priority;
        this.permissions = permissions;
    }

    @NotNull
    public static GangRank read(@NotNull FileConfig config, @NotNull String path, @NotNull String id) {
        String name = (String)ConfigValue.create((String)(path + ".Name"), (String)StringUtil.capitalizeUnderscored((String)id), (String[])new String[0]).read(config);
        int priority = (Integer)ConfigValue.create((String)(path + ".Priority"), (int)0, (String[])new String[0]).read(config);
        Set permissions = Lists.modify((Set)config.getStringSet(path + ".Permissions"), raw -> (GangPermission)Enums.get((String)raw, GangPermission.class));
        permissions.removeIf(Objects::isNull);
        return new GangRank(id, name, priority, permissions);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Name", (Object)this.name);
        config.set(path + ".Priority", (Object)this.priority);
        config.set(path + ".Permissions", (Object)Lists.modify(this.permissions, Enum::name));
    }

    public void inheritancePermissions(@NotNull Set<GangPermission> permissions) {
        this.permissions.addAll(permissions);
    }

    public boolean isPermitted(@NotNull GangPermission permission) {
        return this.permissions.contains((Object)permission) || this.permissions.contains((Object)GangPermission.ALL);
    }

    public boolean isAboveOrEqual(@NotNull GangRank other) {
        return this.isAbove(other) || this.isEqual(other);
    }

    public boolean isAbove(@NotNull GangRank other) {
        return this.priority > other.priority;
    }

    public boolean isEqual(@NotNull GangRank other) {
        return this.priority == other.priority;
    }

    public boolean isUnder(@NotNull GangRank other) {
        return other.isAbove(this);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public Set<GangPermission> getPermissions() {
        return this.permissions;
    }
}

