/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.gang.vault;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentgangs.gang.Gang;

public class GangVault {
    private final UUID gangId;
    private final Map<Integer, ItemStack> itemMap;
    private boolean inUse;

    @NotNull
    public static GangVault create(@NotNull Gang gang) {
        return new GangVault(gang.getId(), new HashMap<Integer, ItemStack>());
    }

    public GangVault(@NotNull UUID gangId, @NotNull Map<Integer, ItemStack> items) {
        this.gangId = gangId;
        this.itemMap = items;
    }

    @Nullable
    public ItemStack getItem(int index) {
        return this.itemMap.get(index);
    }

    public void setItem(int index, @Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir()) {
            this.itemMap.remove(index);
        } else {
            this.itemMap.put(index, new ItemStack(itemStack));
        }
    }

    public int countItems() {
        return this.itemMap.size();
    }

    @NotNull
    public UUID getGangId() {
        return this.gangId;
    }

    @NotNull
    public Map<Integer, ItemStack> getItems() {
        return Map.copyOf(this.itemMap);
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }
}

