/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.registry;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentgangs.api.level.LevelFeature;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.nightcore.bridge.registry.NightRegistry;

public class GangLevels {
    private static final NightRegistry<Integer, GangLevel> REGISTRY = new NightRegistry();

    public static void register(@NotNull GangLevel level) {
        REGISTRY.register((Object)level.getValue(), (Object)level);
    }

    public static void clear() {
        REGISTRY.clear();
    }

    public static void updateInheritance() {
        List<GangLevel> sortedLevels = GangLevels.getLevels().stream().sorted(Comparator.comparingInt(GangLevel::getValue)).toList();
        HashSet<LevelFeature> accumulatedFeatures = new HashSet<LevelFeature>();
        for (GangLevel level : sortedLevels) {
            level.inheritFeatures(accumulatedFeatures);
            accumulatedFeatures.addAll(level.getFeatures());
        }
    }

    public static boolean isPresent() {
        return !REGISTRY.isEmpty();
    }

    public static int count() {
        return REGISTRY.size();
    }

    @Nullable
    public static GangLevel getLevel(int value) {
        return (GangLevel)REGISTRY.byKey((Object)value);
    }

    @NotNull
    public static Optional<GangLevel> level(int value) {
        return Optional.ofNullable(GangLevels.getLevel(value));
    }

    @NotNull
    public static Set<GangLevel> getLevels() {
        return REGISTRY.values();
    }

    @NotNull
    public static GangLevel getFirst() {
        return REGISTRY.map().values().stream().min(Comparator.comparingInt(GangLevel::getValue)).orElseThrow();
    }

    @NotNull
    public static GangLevel getLatest() {
        return REGISTRY.map().values().stream().max(Comparator.comparingInt(GangLevel::getValue)).orElseThrow();
    }

    @NotNull
    public static GangLevel flooring(int value) {
        return REGISTRY.map().values().stream().filter(other -> other.getValue() <= value).max(Comparator.comparingInt(GangLevel::getValue)).orElseThrow();
    }

    @Nullable
    public static GangLevel getNext(@NotNull GangLevel level) {
        return REGISTRY.map().values().stream().filter(other -> other.isAbove(level)).min(Comparator.comparingInt(GangLevel::getValue)).orElse(null);
    }

    @Nullable
    public static GangLevel getPrevious(@NotNull GangLevel level) {
        return REGISTRY.map().values().stream().filter(other -> other.isUnder(level)).max(Comparator.comparingInt(GangLevel::getValue)).orElse(null);
    }
}

