/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.registry;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentgangs.gang.rank.GangPermission;
import su.nightexpress.excellentgangs.gang.rank.GangRank;
import su.nightexpress.nightcore.bridge.registry.NightRegistry;

public class GangRanks {
    public static final NightRegistry<String, GangRank> REGISTRY = new NightRegistry();

    public static void register(@NotNull GangRank rank) {
        REGISTRY.register((Object)rank.getId(), (Object)rank);
    }

    public static void clear() {
        REGISTRY.clear();
    }

    public static void updateInheritance() {
        List<GangRank> sortedRanks = REGISTRY.values().stream().sorted(Comparator.comparingInt(GangRank::getPriority)).toList();
        HashSet<GangPermission> accumulatedPermissions = new HashSet<GangPermission>();
        for (GangRank rank : sortedRanks) {
            rank.inheritancePermissions(accumulatedPermissions);
            accumulatedPermissions.addAll(rank.getPermissions());
        }
    }

    public static boolean isPresent() {
        return !REGISTRY.isEmpty();
    }

    public static int countRegistered() {
        return REGISTRY.size();
    }

    @Nullable
    public static GangRank getById(@NotNull String id) {
        return (GangRank)REGISTRY.byKey((Object)id);
    }

    @NotNull
    public static Optional<GangRank> byId(@NotNull String id) {
        return Optional.ofNullable(GangRanks.getById(id));
    }

    @NotNull
    public static GangRank getLowestRank() {
        return REGISTRY.map().values().stream().min(Comparator.comparingInt(GangRank::getPriority)).orElseThrow();
    }

    @NotNull
    public static GangRank getHighestRank() {
        return REGISTRY.map().values().stream().max(Comparator.comparingInt(GangRank::getPriority)).orElseThrow();
    }

    @Nullable
    public static GangRank getNextRank(@NotNull GangRank rank) {
        return REGISTRY.map().values().stream().filter(other -> other.isAbove(rank)).min(Comparator.comparingInt(GangRank::getPriority)).orElse(null);
    }

    @Nullable
    public static GangRank getPreviousRank(@NotNull GangRank rank) {
        return REGISTRY.map().values().stream().filter(other -> other.isUnder(rank)).max(Comparator.comparingInt(GangRank::getPriority)).orElse(null);
    }
}

