/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.requirement;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentgangs.GangsPlugin;
import su.nightexpress.excellentgangs.requirement.impl.CurrencyLevelRequirement;
import su.nightexpress.excellentgangs.requirement.type.ConfigurableLevelRequirement;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.AbstractManager;

public class LevelRequirementFactory
extends AbstractManager<GangsPlugin> {
    private final Map<String, Loader> loaderMap = new HashMap<String, Loader>();

    public LevelRequirementFactory(@NotNull GangsPlugin plugin) {
        super((NightCorePlugin)plugin);
    }

    protected void onLoad() {
        this.loadDefaults();
    }

    protected void onShutdown() {
        this.loaderMap.clear();
    }

    public void loadDefaults() {
        this.register("currency", CurrencyLevelRequirement::read);
    }

    public void register(@NotNull String type, @NotNull Loader loader) {
        this.loaderMap.put(type, loader);
    }

    @Nullable
    public Loader getLoader(@NotNull String type) {
        return this.loaderMap.get(type);
    }

    @NotNull
    public ConfigurableLevelRequirement parse(@NotNull FileConfig config, @NotNull String path, @NotNull String id) throws IllegalArgumentException {
        String type = (String)ConfigValue.create((String)(path + ".Type"), (String)"null", (String[])new String[0]).read(config);
        Loader loader = this.getLoader(type);
        if (loader == null) {
            throw new IllegalArgumentException("Invalid requirement type '" + type + "'");
        }
        return loader.load(config, path, id);
    }

    public static interface Loader {
        @NotNull
        public ConfigurableLevelRequirement load(@NotNull FileConfig var1, @NotNull String var2, @NotNull String var3);
    }
}

