/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.requirement.impl;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.gang.Gang;
import su.nightexpress.excellentgangs.requirement.type.ConfigurableLevelRequirement;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.currency.EconomyBridge;
import su.nightexpress.nightcore.util.NumberUtil;

public class CurrencyLevelRequirement
extends ConfigurableLevelRequirement {
    private final String currencyId;
    private final double amount;

    public CurrencyLevelRequirement(@NotNull String id, @NotNull String currencyId, double amount) {
        super("currency", id);
        this.currencyId = currencyId;
        this.amount = amount;
    }

    @NotNull
    public static CurrencyLevelRequirement read(@NotNull FileConfig config, @NotNull String path, @NotNull String id) {
        String currencyId = (String)ConfigValue.create((String)(path + ".CurrencyId"), (String)"vault", (String[])new String[0]).read(config);
        double amount = (Double)ConfigValue.create((String)(path + ".Amount"), (double)0.0, (String[])new String[0]).read(config);
        return new CurrencyLevelRequirement(id, currencyId, amount);
    }

    @Override
    protected void writeAdditional(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".CurrencyId", (Object)this.currencyId);
        config.set(path + ".Amount", (Object)this.amount);
    }

    @NotNull
    private Optional<Currency> currency() {
        return EconomyBridge.currency((String)this.currencyId);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.currency().map(Currency::getName).orElse(this.currencyId);
    }

    @Override
    @NotNull
    public String getFormatted() {
        return this.currency().map(currency -> currency.format(this.amount)).orElse(NumberUtil.format((double)this.amount));
    }

    @Override
    public boolean isMet(@NotNull Gang gang) {
        return gang.getBank().hasEnough(this.currencyId, this.amount);
    }

    @Override
    public void pay(@NotNull Gang gang) {
        gang.getBank().withdraw(this.currencyId, this.amount);
    }

    @Override
    public void refund(@NotNull Gang gang) {
        gang.getBank().deposit(this.currencyId, this.amount);
    }
}

