/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentgangs.util;

import java.util.Comparator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentgangs.api.level.LevelFeature;
import su.nightexpress.excellentgangs.api.level.LevelRequirement;
import su.nightexpress.excellentgangs.config.Config;
import su.nightexpress.excellentgangs.config.Lang;
import su.nightexpress.excellentgangs.gang.level.GangLevel;
import su.nightexpress.nightcore.bridge.currency.Currency;
import su.nightexpress.nightcore.core.config.CoreLang;

public class GangUtils {
    private static Pattern namePattern;

    public static void setNamePattern(@NotNull String pattern) {
        namePattern = Pattern.compile(pattern);
    }

    public static boolean isValidName(@NotNull String name) {
        Matcher matcher = namePattern.matcher(name);
        return matcher.matches();
    }

    public static boolean isAllowedBankCurrency(@NotNull Currency currency) {
        return GangUtils.isAllowedBankCurrency(currency.getInternalId());
    }

    public static boolean isAllowedBankCurrency(@NotNull String currencyId) {
        return ((Set)Config.BANK_ALLOWED_CURRENCIES.get()).contains(currencyId) || ((Set)Config.BANK_ALLOWED_CURRENCIES.get()).contains("*");
    }

    @NotNull
    public static String formatRequirements(@NotNull GangLevel level) {
        if (!level.hasRequirements()) {
            return CoreLang.OTHER_NONE.text();
        }
        return level.getUpgradeRequirements().stream().sorted(Comparator.comparing(LevelRequirement::getDisplayName)).map(LevelRequirement::getFormatted).collect(Collectors.joining(", "));
    }

    @NotNull
    public static String formatFeatures(@NotNull GangLevel level) {
        if (!level.hasRequirements()) {
            return Lang.OTHER_LEVEL_FEATURE_EMPTY.text();
        }
        return level.getFeatures().stream().sorted(Comparator.comparingInt(Enum::ordinal)).map(feature -> (level.hasFeature((LevelFeature)((Object)feature)) ? Lang.OTHER_LEVEL_FEATURE_AVAILABLE : Lang.OTHER_LEVEL_FEATURE_UNAVAILABLE).text().replace("%name%", Lang.OTHER_LEVEL_FEATURE_NAME.getLocalized((Enum)feature))).collect(Collectors.joining("\n"));
    }
}

