/*
 * Decompiled with CFR 0.152.
 */
package net.archers.client.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.render.LightEmission;

public class HuntersMarkRenderer
implements CustomModelStatusEffect.Renderer {
    public static final ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"effect/hunters_mark");
    private static final RenderType GLOWING_RENDER_LAYER = CustomLayers.spellEffect((LightEmission)LightEmission.GLOW, (boolean)false);

    public void renderEffect(int amplifier, LivingEntity livingEntity, float delta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        if (livingEntity.getHealth() <= 0.0f || !livingEntity.isAlive()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 direction = camera.getPosition().subtract(livingEntity.position()).normalize().scale((double)(livingEntity.getBbWidth() * 0.5f));
        matrixStack.pushPose();
        float verticalOffset = livingEntity.getBbHeight() / livingEntity.getScale() * 0.75f;
        matrixStack.translate(direction.x, (double)verticalOffset, direction.z);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f + (float)Math.toDegrees(Math.atan2(direction.x, direction.z))));
        matrixStack.mulPose(Axis.XP.rotationDegrees(camera.getXRot()));
        CustomModels.render((RenderType)GLOWING_RENDER_LAYER, (ItemRenderer)itemRenderer, (ResourceLocation)modelId, (PoseStack)matrixStack, (MultiBufferSource)vertexConsumers, (int)light, (int)livingEntity.getId());
        matrixStack.popPose();
    }
}

