/*
 * Decompiled with CFR 0.152.
 */
package net.archers.content;

import java.util.ArrayList;
import java.util.List;
import net.archers.block.ArcherWorkbenchBlock;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class ArcherSounds {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry MARKER_SHOT = ArcherSounds.add(new Entry("marker_shot"));
    public static final Entry ENTANGLING_ROOTS = ArcherSounds.add(new Entry("entangling_roots"));
    public static final Entry BOW_PULL = ArcherSounds.add(new Entry("bow_pull"));
    public static final Entry MAGIC_ARROW_IMPACT = ArcherSounds.add(new Entry("magic_arrow_impact"));
    public static final Entry MAGIC_ARROW_RELEASE = ArcherSounds.add(new Entry("magic_arrow_release"));
    public static final Entry MAGIC_ARROW_START = ArcherSounds.add(new Entry("magic_arrow_start"));
    public static final Entry WORKBENCH = ArcherSounds.add(new Entry(ArcherWorkbenchBlock.ID.getPath()));
    public static final Entry ARCHER_ARMOR_EQUIP = ArcherSounds.add(new Entry("archer_armor"));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)entry.id(), (Object)entry.soundEvent());
        }
    }

    public static class Entry {
        private final ResourceLocation id;
        private final SoundEvent soundEvent;
        private Holder<SoundEvent> entry;
        private int variants = 1;

        public Entry(ResourceLocation id, SoundEvent soundEvent) {
            this.id = id;
            this.soundEvent = soundEvent;
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"archers", (String)name));
        }

        public Entry(ResourceLocation id) {
            this(id, SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        }

        public Entry travelDistance(float distance) {
            return new Entry(this.id, SoundEvent.createFixedRangeEvent((ResourceLocation)this.id, (float)distance));
        }

        public Entry variants(int variants) {
            this.variants = variants;
            return this;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SoundEvent soundEvent() {
            return this.soundEvent;
        }

        public Holder<SoundEvent> entry() {
            return this.entry;
        }

        public int variants() {
            return this.variants;
        }
    }
}

