/*
 * Decompiled with CFR 0.152.
 */
package net.archers.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.archers.content.ArcherSounds;
import net.archers.content.ArcherSpells;
import net.archers.datagen.ArcherRecipes;
import net.archers.item.ArcherArmors;
import net.archers.item.ArcherWeapons;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class ArchersDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(SoundGen::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(ArcherRecipes::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, ArcherArmors.archerArmorSet_T1, Items.LEATHER);
            UnsmeltGenerator.disassembleArmor(exporter, ArcherArmors.archerArmorSet_T2, Items.TURTLE_SCUTE);
            UnsmeltGenerator.disassembleArmor(exporter, ArcherArmors.archerArmorSet_T3, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassemble(exporter, ArcherWeapons.meleeEntries.stream().filter(entry -> entry.id().getPath().contains("flint")).map(entry -> entry.item()).toList(), Items.FLINT);
            UnsmeltGenerator.disassemble(exporter, ArcherWeapons.meleeEntries.stream().filter(entry -> entry.id().getPath().contains("gold")).map(entry -> entry.item()).toList(), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, ArcherWeapons.meleeEntries.stream().filter(entry -> entry.id().getPath().contains("iron")).map(entry -> entry.item()).toList(), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, ArcherWeapons.meleeEntries.stream().filter(entry -> entry.id().getPath().contains("netherite")).map(entry -> entry.item()).toList(), Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassemble(exporter, List.of(ArcherWeapons.mechanic_shortbow.item(), ArcherWeapons.rapid_crossbow.item()), Items.REDSTONE);
            UnsmeltGenerator.disassemble(exporter, List.of(ArcherWeapons.royal_longbow.item()), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(ArcherWeapons.heavy_crossbow.item()), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, ArcherWeapons.rangedEntries.stream().filter(entry -> entry.id().getPath().contains("netherite")).map(entry -> entry.item()).toList(), Items.NETHERITE_SCRAP);
        }

        private static void disassembleArmor(RecipeOutput exporter, Armor.Set armorSet, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassemble(RecipeOutput exporter, List<ItemLike> items, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("archers", ArcherSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().getPath(), (int)entry.variants())).toList()));
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ArcherSpells.Entry entry : ArcherSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            this.generateWeaponTags(ArcherWeapons.meleeEntries);
            List<RPGSeriesDataGen.BowEntry> bowEntries = ArcherWeapons.rangedEntries.stream().map(entry -> new RPGSeriesDataGen.BowEntry(entry.id(), entry.weaponType, entry.lootProperties)).toList();
            this.generateBowTags(bowEntries);
            this.generateArmorTags(ArcherArmors.entries, RPGSeriesItemTags.ArmorMetaType.ARCHERY);
        }
    }
}

