/*
 * Decompiled with CFR 0.152.
 */
package net.archers.item;

import com.github.theredbrain.bundleapi.BundleAPI;
import com.github.theredbrain.bundleapi.component.type.CustomBundleContentsComponent;
import com.github.theredbrain.bundleapi.item.CustomBundleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.archers.item.Group;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class Quivers {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Function<Args, Item> factory = args -> new CustomBundleItem(args.tag, args.settings);

    public static Entry entry(String name, int capacity, @Nullable Rarity rarity) {
        Item.Properties settings = new Item.Properties().stacksTo(1).component(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"item.archers.quiver.hint").withStyle(ChatFormatting.GRAY)))).component(BundleAPI.CUSTOM_BUNDLE_CONTENTS_COMPONENT, (Object)CustomBundleContentsComponent.builder().size_multiplier(capacity).build());
        if (rarity != null) {
            settings.rarity(rarity);
        }
        Item bundle = factory.apply(new Args((TagKey<Item>)ItemTags.ARROWS, settings));
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"archers", (String)name);
        Entry entry = new Entry(id, capacity, bundle);
        entries.add(entry);
        return entry;
    }

    public static void register() {
        Quivers.entry("small_quiver", 4, null);
        Quivers.entry("medium_quiver", 8, null);
        Quivers.entry("large_quiver", 12, Rarity.UNCOMMON);
        for (Entry entry : entries) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)entry.item());
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : entries) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public record Args(TagKey<Item> tag, Item.Properties settings) {
    }

    public record Entry(ResourceLocation id, int capacity, Item item) {
    }
}

