/*
 * Decompiled with CFR 0.152.
 */
package net.archers.datagen;

import java.util.concurrent.CompletableFuture;
import net.archers.block.ArcherBlocks;
import net.archers.item.ArcherArmors;
import net.archers.item.ArcherWeapons;
import net.archers.item.misc.Misc;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;

public class ArcherRecipes
extends FabricRecipeProvider {
    public ArcherRecipes(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    public void buildRecipes(RecipeOutput exporter) {
        this.generateSpearRecipes(exporter);
        this.generateBowRecipes(exporter);
        this.generateCrossbowRecipes(exporter);
        this.generateArmorRecipes(exporter);
        this.generateOtherRecipes(exporter);
        this.generateNetheriteUpgrades(exporter);
    }

    private void generateSpearRecipes(RecipeOutput exporter) {
        this.spear(exporter, ArcherWeapons.flint_spear, Items.FLINT);
        this.spear(exporter, ArcherWeapons.iron_spear, Items.IRON_INGOT);
        this.spear(exporter, ArcherWeapons.golden_spear, Items.GOLD_INGOT);
        this.spear(exporter, ArcherWeapons.diamond_spear, Items.DIAMOND);
    }

    private void spear(RecipeOutput exporter, Weapon.Entry spearEntry, Item tipMaterial) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)spearEntry.item()).pattern("  P").pattern(" # ").pattern("#  ").define(Character.valueOf('P'), (ItemLike)tipMaterial).define(Character.valueOf('#'), (ItemLike)Items.STICK).unlockedBy(ArcherRecipes.getHasName((ItemLike)tipMaterial), ArcherRecipes.has((ItemLike)tipMaterial)).save(exporter);
    }

    private void generateBowRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)ArcherWeapons.composite_longbow.item()).pattern(" #X").pattern("B X").pattern(" #X").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('B'), (ItemLike)Items.BONE).define(Character.valueOf('X'), (ItemLike)Items.STRING).unlockedBy(ArcherRecipes.getHasName((ItemLike)Items.BONE), ArcherRecipes.has((ItemLike)Items.BONE)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)ArcherWeapons.mechanic_shortbow.item()).pattern(" IX").pattern("R X").pattern(" IX").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('X'), (ItemLike)Items.STRING).unlockedBy(ArcherRecipes.getHasName((ItemLike)Items.REDSTONE), ArcherRecipes.has((ItemLike)Items.REDSTONE)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)ArcherWeapons.royal_longbow.item()).pattern(" GX").pattern("D X").pattern(" GX").define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('X'), (ItemLike)Items.STRING).unlockedBy(ArcherRecipes.getHasName((ItemLike)Items.DIAMOND), ArcherRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateCrossbowRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)ArcherWeapons.rapid_crossbow.item()).pattern("IRI").pattern("XTX").pattern(" I ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('X'), (ItemLike)Items.STRING).define(Character.valueOf('T'), (ItemLike)Items.TRIPWIRE_HOOK).unlockedBy(ArcherRecipes.getHasName((ItemLike)Items.REDSTONE), ArcherRecipes.has((ItemLike)Items.REDSTONE)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)ArcherWeapons.heavy_crossbow.item()).pattern("IDI").pattern("XTX").pattern(" I ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('X'), (ItemLike)Items.STRING).define(Character.valueOf('T'), (ItemLike)Items.TRIPWIRE_HOOK).unlockedBy(ArcherRecipes.getHasName((ItemLike)Items.DIAMOND), ArcherRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateArmorRecipes(RecipeOutput exporter) {
        this.generateArcherArmorSet(exporter, ArcherArmors.archerArmorSet_T1, Items.LEATHER, Items.CHAIN);
        this.generateRangerArmorSet(exporter, ArcherArmors.archerArmorSet_T2, Items.LEATHER, Items.RABBIT_HIDE, Items.TURTLE_SCUTE);
    }

    private void generateArcherArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item leather, Item chain) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("LLL").pattern("C C").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('C'), (ItemLike)chain).unlockedBy(ArcherRecipes.getHasName((ItemLike)chain), ArcherRecipes.has((ItemLike)chain)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("C C").pattern("LLL").pattern("LLL").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('C'), (ItemLike)chain).unlockedBy(ArcherRecipes.getHasName((ItemLike)chain), ArcherRecipes.has((ItemLike)chain)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("CCC").pattern("L L").pattern("L L").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('C'), (ItemLike)chain).unlockedBy(ArcherRecipes.getHasName((ItemLike)chain), ArcherRecipes.has((ItemLike)chain)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("C C").pattern("L L").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('C'), (ItemLike)chain).unlockedBy(ArcherRecipes.getHasName((ItemLike)chain), ArcherRecipes.has((ItemLike)chain)).save(exporter);
    }

    private void generateRangerArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item leather, Item rabbitHide, Item turtleScute) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("SRS").pattern("L L").define(Character.valueOf('S'), (ItemLike)turtleScute).define(Character.valueOf('R'), (ItemLike)rabbitHide).define(Character.valueOf('L'), (ItemLike)leather).unlockedBy(ArcherRecipes.getHasName((ItemLike)turtleScute), ArcherRecipes.has((ItemLike)turtleScute)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("R R").pattern("LSL").pattern("LLL").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('R'), (ItemLike)rabbitHide).define(Character.valueOf('S'), (ItemLike)turtleScute).unlockedBy(ArcherRecipes.getHasName((ItemLike)turtleScute), ArcherRecipes.has((ItemLike)turtleScute)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("SRS").pattern("L L").pattern("L L").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('R'), (ItemLike)rabbitHide).define(Character.valueOf('S'), (ItemLike)turtleScute).unlockedBy(ArcherRecipes.getHasName((ItemLike)turtleScute), ArcherRecipes.has((ItemLike)turtleScute)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("R R").pattern("L L").define(Character.valueOf('L'), (ItemLike)leather).define(Character.valueOf('R'), (ItemLike)rabbitHide).unlockedBy(ArcherRecipes.getHasName((ItemLike)rabbitHide), ArcherRecipes.has((ItemLike)rabbitHide)).save(exporter);
    }

    private void generateOtherRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ArcherBlocks.WORKBENCH.block()).pattern("SAL").pattern("###").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('A'), (ItemLike)Items.ARROW).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('#'), ItemTags.PLANKS).unlockedBy(ArcherRecipes.getHasName((ItemLike)Items.ARROW), ArcherRecipes.has((ItemLike)Items.ARROW)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Misc.autoFireHook.item()).pattern("C  ").pattern("C I").pattern(" R ").define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).unlockedBy(ArcherRecipes.getHasName((ItemLike)Items.COPPER_INGOT), ArcherRecipes.has((ItemLike)Items.COPPER_INGOT)).save(exporter);
    }

    private void generateNetheriteUpgrades(RecipeOutput exporter) {
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherWeapons.diamond_spear.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherWeapons.netherite_spear.item());
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherWeapons.royal_longbow.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherWeapons.netherite_longbow.item());
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherWeapons.mechanic_shortbow.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherWeapons.netherite_shortbow.item());
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherWeapons.rapid_crossbow.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherWeapons.netherite_rapid_crossbow.item());
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherWeapons.heavy_crossbow.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherWeapons.netherite_heavy_crossbow.item());
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherArmors.archerArmorSet_T2.head, (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherArmors.archerArmorSet_T3.head);
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherArmors.archerArmorSet_T2.chest, (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherArmors.archerArmorSet_T3.chest);
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherArmors.archerArmorSet_T2.legs, (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherArmors.archerArmorSet_T3.legs);
        ArcherRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)ArcherArmors.archerArmorSet_T2.feet, (RecipeCategory)RecipeCategory.COMBAT, (Item)ArcherArmors.archerArmorSet_T3.feet);
    }

    public String getName() {
        return "Archer Crafting Recipes";
    }
}

