/*
 * Decompiled with CFR 0.152.
 */
package net.archers.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.archers.block.ArcherBlocks;
import net.archers.content.ArcherSounds;
import net.archers.item.ArcherArmors;
import net.archers.item.ArcherWeapons;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ArcherVillagers {
    public static final String ARCHERY_ARTISAN = "archery_artisan";
    public static final ResourceLocation POI_ID = ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"archery_artisan");

    public static void registerPOI() {
        ImmutableSet blockStates = ImmutableSet.copyOf((Collection)ArcherBlocks.WORKBENCH.block().getStateDefinition().getPossibleStates());
        PointOfInterestHelper.register((ResourceLocation)POI_ID, (int)1, (int)10, (Iterable)blockStates);
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"archers", (String)name);
        return (VillagerProfession)Registry.register((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"archers", (String)name), (Object)new VillagerProfession(id.toString(), entry -> entry.is(workStation), entry -> entry.is(workStation), ImmutableSet.of(), ImmutableSet.of(), ArcherSounds.WORKBENCH.soundEvent()));
    }

    public static void registerVillagers() {
        VillagerProfession profession = ArcherVillagers.registerProfession(ARCHERY_ARTISAN, (ResourceKey<PoiType>)ResourceKey.create((ResourceKey)BuiltInRegistries.POINT_OF_INTEREST_TYPE.key(), (ResourceLocation)POI_ID));
        LinkedHashMap<Integer, List<Object>> trades = new LinkedHashMap<Integer, List<Object>>();
        trades.put(1, List.of(new VillagerTrades.ItemsForEmeralds(Items.ARROW, 2, 8, 128, 3, 0.01f), new VillagerTrades.EmeraldForItems((ItemLike)Items.LEATHER, 8, 12, 6, 5)));
        trades.put(2, List.of(new VillagerTrades.ItemsForEmeralds(ArcherWeapons.composite_longbow.item(), 6, 1, 16), new VillagerTrades.ItemsForEmeralds((Item)ArcherArmors.archerArmorSet_T1.head, 15, 1, 18), new VillagerTrades.EmeraldForItems((ItemLike)Items.STRING, 6, 12, 8, 3)));
        trades.put(3, List.of(new VillagerTrades.ItemsForEmeralds((Item)ArcherArmors.archerArmorSet_T1.feet, 15, 1, 18), new VillagerTrades.EmeraldForItems((ItemLike)Items.REDSTONE, 12, 12, 5, 8), new VillagerTrades.ItemsForEmeralds((Item)ArcherArmors.archerArmorSet_T1.legs, 15, 1, 18)));
        trades.put(4, List.of(new VillagerTrades.ItemsForEmeralds((Item)ArcherArmors.archerArmorSet_T1.chest, 15, 1, 18), new VillagerTrades.ItemsForEmeralds(Items.TURTLE_SCUTE, 20, 12, 10)));
        for (Map.Entry entry : trades.entrySet()) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)((Integer)entry.getKey()), factories -> factories.addAll((Collection)entry.getValue()));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(ArcherWeapons.royal_longbow.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(ArcherWeapons.mechanic_shortbow.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(ArcherWeapons.rapid_crossbow.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(ArcherWeapons.heavy_crossbow.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
        });
    }
}

