/*
 * Decompiled with CFR 0.152.
 */
package com.aeniruo.dimensionentityblocker.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DEFAULT_BANNED_ENTITIES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> WORLD_SPECIFIC_CONFIGS;
    private static final Map<ResourceLocation, Set<String>> worldBannedEntities;
    private static Set<String> defaultBannedEntities;

    public static void reload() {
        worldBannedEntities.clear();
        defaultBannedEntities.clear();
        for (String entityId : (List)DEFAULT_BANNED_ENTITIES.get()) {
            defaultBannedEntities.add(entityId);
        }
        for (String configEntry : (List)WORLD_SPECIFIC_CONFIGS.get()) {
            try {
                String[] entityArray;
                String[] parts = configEntry.split(":", 3);
                if (parts.length != 3) continue;
                String worldNamespace = parts[0];
                String worldPath = parts[1];
                String entitiesStr = parts[2];
                ResourceLocation worldId = ResourceLocation.fromNamespaceAndPath((String)worldNamespace, (String)worldPath);
                HashSet<String> bannedEntities = new HashSet<String>();
                for (String entityId : entityArray = entitiesStr.split(",")) {
                    bannedEntities.add(entityId.trim());
                }
                worldBannedEntities.put(worldId, bannedEntities);
            }
            catch (Exception e) {
                System.err.println("\u89e3\u6790\u4e16\u754c\u914d\u7f6e\u5931\u8d25: " + configEntry + " - " + e.getMessage());
            }
        }
    }

    public static void reloadConfigFile() throws IOException {
        Path configPath = Path.of(ConfigTracker.INSTANCE.getConfigFileName("dimensionentityblocker", ModConfig.Type.COMMON), new String[0]);
        CommentedFileConfig commentedFileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        ConfigTracker.INSTANCE.configSets().forEach((type, configSet) -> {
            if (type == ModConfig.Type.COMMON) {
                configSet.forEach(config -> {
                    if (config.getModId().equals("dimensionentityblocker")) {
                        commentedFileConfig.load();
                        config.getSpec().acceptConfig((CommentedConfig)commentedFileConfig);
                        config.getSpec().afterReload();
                    }
                });
            }
        });
        Config.reload();
    }

    public static boolean isEntityBanned(ResourceLocation worldId, String entityId) {
        if (worldBannedEntities.containsKey(worldId) && worldBannedEntities.get(worldId).contains(entityId)) {
            return true;
        }
        return defaultBannedEntities.contains(entityId);
    }

    public static Set<String> getBannedEntitiesForWorld(ResourceLocation worldId) {
        if (worldBannedEntities.containsKey(worldId)) {
            return worldBannedEntities.get(worldId);
        }
        return defaultBannedEntities;
    }

    public static Map<ResourceLocation, Set<String>> getAllWorldConfigs() {
        return new HashMap<ResourceLocation, Set<String>>(worldBannedEntities);
    }

    public static Set<String> getDefaultBannedEntities() {
        return new HashSet<String>(defaultBannedEntities);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        DEFAULT_BANNED_ENTITIES = builder.comment(new String[]{"\u9ed8\u8ba4\u7981\u6b62\u8fdb\u5165\u4e16\u754c\u7684\u5b9e\u4f53ID\u5217\u8868", "\u6bd4\u5982\u901a\u8fc7\u4f20\u9001\u95e8\u3001\u4f20\u9001\u7b49\u65b9\u5f0f\u8fdb\u5165\u4e16\u754c", "\u683c\u5f0f: [\"minecraft:zombie\", \"minecraft:skeleton\"]"}).defineList("default_banned_entities", List.of(), obj -> obj instanceof String);
        WORLD_SPECIFIC_CONFIGS = builder.comment(new String[]{"\u4e16\u754c\u7279\u5b9a\u914d\u7f6e", "\u683c\u5f0f: [\"world_id1:entity1,entity2\", \"world_id2:entity3,entity4\"]", "\u793a\u4f8b: [\"minecraft:the_end:minecraft:falling_block,minecraft:zombie\", \"minecraft:the_nether:minecraft:creeper\"]", "\u652f\u6301\u7684\u4e16\u754cID\u5982: minecraft:overworld, minecraft:the_nether, minecraft:the_end, \u6216\u81ea\u5b9a\u4e49\u4e16\u754c"}).defineList("world_specific_configs", List.of(), obj -> obj instanceof String);
        SPEC = builder.build();
        worldBannedEntities = new HashMap<ResourceLocation, Set<String>>();
        defaultBannedEntities = new HashSet<String>();
        Config.reload();
    }
}

