/*
 * Decompiled with CFR 0.152.
 */
package com.aeniruo.dimensionentityblocker.events;

import com.aeniruo.dimensionentityblocker.config.Config;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTravelToDimensionEventHandler {
    @SubscribeEvent
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        ResourceLocation targetDimension = event.getDimension().m_135782_();
        Entity entity = event.getEntity();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId != null && Config.isEntityBanned(targetDimension, entityId.toString())) {
            event.setCanceled(true);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                String dimensionName = EntityTravelToDimensionEventHandler.getDimensionDisplayName(targetDimension);
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7c\u7981\u6b62\u73a9\u5bb6\u8fdb\u5165 " + dimensionName)), true);
            }
        }
    }

    private static String getDimensionDisplayName(ResourceLocation dimensionId) {
        switch (dimensionId.toString()) {
            case "minecraft:overworld": {
                return "\u4e3b\u4e16\u754c";
            }
            case "minecraft:the_nether": {
                return "\u4e0b\u754c";
            }
            case "minecraft:the_end": {
                return "\u672b\u5730";
            }
        }
        return dimensionId.toString();
    }
}

