/*
 * Decompiled with CFR 0.152.
 */
package com.aeniruo.dimensionentityblocker;

import com.aeniruo.dimensionentityblocker.config.Config;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class CommandRegister {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dimensionentityblocker").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(CommandRegister::reloadConfig))).then(Commands.m_82127_((String)"list").executes(CommandRegister::listAllConfigs))).then(Commands.m_82127_((String)"worlds").executes(CommandRegister::listWorldConfigs))).then(Commands.m_82127_((String)"default").executes(CommandRegister::listDefaultConfig))).then(Commands.m_82127_((String)"help").executes(CommandRegister::showHelp)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"deb").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(CommandRegister::reloadConfig))).then(Commands.m_82127_((String)"list").executes(CommandRegister::listAllConfigs))).then(Commands.m_82127_((String)"worlds").executes(CommandRegister::listWorldConfigs))).then(Commands.m_82127_((String)"default").executes(CommandRegister::listDefaultConfig))).then(Commands.m_82127_((String)"help").executes(CommandRegister::showHelp)));
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        try {
            Config.reloadConfigFile();
            int defaultCount = Config.getDefaultBannedEntities().size();
            int worldCount = Config.getAllWorldConfigs().size();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a\u914d\u7f6e\u5df2\u91cd\u8f7d\uff01\u9ed8\u8ba4\u7981\u6b62 \u00a7e" + defaultCount + " \u00a7a\u4e2a\u5b9e\u4f53\uff0c\u4e3a \u00a7e" + worldCount + " \u00a7a\u4e2a\u4e16\u754c\u914d\u7f6e\u4e86\u7279\u5b9a\u89c4\u5219")), true);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u8f7d\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c\u91cd\u8f7d\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage())));
            return 0;
        }
    }

    private static int listAllConfigs(CommandContext<CommandSourceStack> context) {
        Set<String> defaultEntities = Config.getDefaultBannedEntities();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76=== \u9ed8\u8ba4\u7981\u6b62\u7684\u5b9e\u4f53 (\u00a7e" + defaultEntities.size() + "\u00a76\u4e2a) ===")), false);
        if (defaultEntities.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77\u65e0"), false);
        } else {
            int index = 1;
            for (String entityId : defaultEntities) {
                int currentIndex = index++;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77" + currentIndex + ". \u00a7f" + entityId)), false);
            }
        }
        Map<ResourceLocation, Set<String>> worldConfigs = Config.getAllWorldConfigs();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76=== \u4e16\u754c\u7279\u5b9a\u914d\u7f6e (\u00a7e" + worldConfigs.size() + "\u00a76\u4e2a\u4e16\u754c) ===")), false);
        if (worldConfigs.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77\u65e0"), false);
        } else {
            int worldIndex = 1;
            for (Map.Entry<ResourceLocation, Set<String>> entry : worldConfigs.entrySet()) {
                int currentWorldIndex = worldIndex++;
                ResourceLocation worldId = entry.getKey();
                Set<String> entities = entry.getValue();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7b" + currentWorldIndex + ". \u4e16\u754c: \u00a7e" + String.valueOf(worldId) + " \u00a7b(\u00a7e" + entities.size() + "\u00a7b\u4e2a\u5b9e\u4f53)")), false);
                int entityIndex = 1;
                for (String entityId : entities) {
                    int currentEntityIndex = entityIndex++;
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("   \u00a77" + currentEntityIndex + ". \u00a7f" + entityId)), false);
                }
            }
        }
        return 1;
    }

    private static int listWorldConfigs(CommandContext<CommandSourceStack> context) {
        Map<ResourceLocation, Set<String>> worldConfigs = Config.getAllWorldConfigs();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76=== \u4e16\u754c\u7279\u5b9a\u914d\u7f6e (\u00a7e" + worldConfigs.size() + "\u00a76\u4e2a\u4e16\u754c) ===")), false);
        if (worldConfigs.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77\u6ca1\u6709\u914d\u7f6e\u4e16\u754c\u7279\u5b9a\u89c4\u5219"), false);
        } else {
            int index = 1;
            for (Map.Entry<ResourceLocation, Set<String>> entry : worldConfigs.entrySet()) {
                int currentIndex = index++;
                ResourceLocation worldId = entry.getKey();
                Set<String> entities = entry.getValue();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7b" + currentIndex + ". \u00a7e" + String.valueOf(worldId) + " \u00a7b(\u00a7e" + entities.size() + "\u00a7b\u4e2a\u5b9e\u4f53)")), false);
                for (String entityId : entities) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("   \u00a77- \u00a7f" + entityId)), false);
                }
            }
        }
        return 1;
    }

    private static int listDefaultConfig(CommandContext<CommandSourceStack> context) {
        Set<String> defaultEntities = Config.getDefaultBannedEntities();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76=== \u9ed8\u8ba4\u7981\u6b62\u7684\u5b9e\u4f53 (\u00a7e" + defaultEntities.size() + "\u00a76\u4e2a) ===")), false);
        if (defaultEntities.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77\u5f53\u524d\u6ca1\u6709\u9ed8\u8ba4\u7981\u6b62\u4efb\u4f55\u5b9e\u4f53"), false);
        } else {
            int index = 1;
            for (String entityId : defaultEntities) {
                int currentIndex = index++;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77" + currentIndex + ". \u00a7f" + entityId)), false);
            }
        }
        return 1;
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a76=== \u5b9e\u4f53\u8fdb\u5165\u4e16\u754c\u963b\u6b62\u5668\u547d\u4ee4\u5e2e\u52a9 ==="), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7a/deb reload \u00a77- \u91cd\u8f7d\u914d\u7f6e\u6587\u4ef6"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7a/deb list \u00a77- \u663e\u793a\u6240\u6709\u914d\u7f6e\uff08\u9ed8\u8ba4+\u4e16\u754c\u7279\u5b9a\uff09"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7a/deb worlds \u00a77- \u663e\u793a\u4e16\u754c\u7279\u5b9a\u914d\u7f6e"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7a/deb default \u00a77- \u663e\u793a\u9ed8\u8ba4\u914d\u7f6e"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7a/deb help \u00a77- \u663e\u793a\u6b64\u5e2e\u52a9\u4fe1\u606f"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77\u914d\u7f6e\u6587\u4ef6\u4f4d\u7f6e: config/dimensionentityblocker-common.toml"), false);
        return 1;
    }
}

