/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.elytraslot_compat.config;

import com.Minor2CCh.elytraslot_compat.ElytraslotCompat;
import com.Minor2CCh.elytraslot_compat.config.ECConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.include.com.google.gson.Gson;
import org.spongepowered.include.com.google.gson.GsonBuilder;

public class ECConfigLoader {
    private static final File DIR = ElytraslotCompat.PLATFORM.getConfigPath().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILENAME = "elytraslot_compat.json";
    private static final Path CONFIG_PATH = Path.of(new File(DIR, "elytraslot_compat.json").getPath(), new String[0]);
    private static ECConfig modConfig;

    public static void load() {
        System.out.println(CONFIG_PATH);
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                modConfig = (ECConfig)GSON.fromJson((Reader)reader, ECConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
                modConfig = new ECConfig();
            }
            try {
                modConfig.fillDefaults();
            }
            catch (Exception e) {
                System.err.println("Failed to load config: " + e.getMessage());
                modConfig = new ECConfig();
            }
            modConfig.fillDefaults();
        } else {
            modConfig = new ECConfig();
        }
        ECConfigLoader.save();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)modConfig, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public static ECConfig getConfig() {
        return modConfig;
    }
}

