/*
 * Decompiled with CFR 0.152.
 */
package com.Minor2CCh.elytraslot_compat.neoforge;

import com.Minor2CCh.elytraslot_compat.ElytraslotCompat;
import com.Minor2CCh.elytraslot_compat.config.ECConfigLoader;
import com.Minor2CCh.elytraslot_compat.neoforge.ExtraCompatibilityProviderNeoForge;
import com.Minor2CCh.elytraslot_compat.neoforge.mixin.ElytraSlotProviderAccessorNeoForge;
import com.Minor2CCh.elytraslot_compat.neoforge.platform.NeoForgePlatform;
import com.Minor2CCh.elytraslot_compat.registry.ECItemTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;

@EventBusSubscriber(modid="elytraslot_compat")
@Mod(value="elytraslot_compat")
public final class ElytraslotCompatNeoForge {
    public ElytraslotCompatNeoForge() {
        ElytraslotCompat.PLATFORM = new NeoForgePlatform();
        ElytraslotCompat.init();
        ElytraSlotProviderAccessorNeoForge.getProvider().add(new ExtraCompatibilityProviderNeoForge());
    }

    @SubscribeEvent
    public static void onCurioAttributeModifiers(CurioAttributeModifierEvent event) {
        if (!ECConfigLoader.getConfig().enableArmorValue.booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.is(ECItemTags.ELYTRA_SLOT_ALLOW)) {
            ItemAttributeModifiers modifiers = stack.getAttributeModifiers();
            List entries = modifiers.modifiers();
            Map<AttributeModifier.Operation, Double> armor = ElytraslotCompatNeoForge.createHashMap();
            Map<AttributeModifier.Operation, Double> toughness = ElytraslotCompatNeoForge.createHashMap();
            Map<AttributeModifier.Operation, Double> knockbackResistance = ElytraslotCompatNeoForge.createHashMap();
            for (ItemAttributeModifiers.Entry entry : entries) {
                AttributeModifier modifier;
                if (entry.attribute().equals((Object)Attributes.ARMOR)) {
                    modifier = entry.modifier();
                    ElytraslotCompatNeoForge.calcModifier(armor, modifier);
                    continue;
                }
                if (entry.attribute().equals((Object)Attributes.ARMOR_TOUGHNESS)) {
                    modifier = entry.modifier();
                    ElytraslotCompatNeoForge.calcModifier(toughness, modifier);
                    continue;
                }
                if (!entry.attribute().equals((Object)Attributes.KNOCKBACK_RESISTANCE)) continue;
                modifier = entry.modifier();
                ElytraslotCompatNeoForge.calcModifier(knockbackResistance, modifier);
            }
            armor.forEach((operation, value) -> event.addModifier(Attributes.ARMOR, new AttributeModifier(ElytraslotCompatNeoForge.getModifierId((Holder<Attribute>)Attributes.ARMOR, operation, event.getSlotContext()), value.doubleValue(), operation)));
            toughness.forEach((operation, value) -> event.addModifier(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ElytraslotCompatNeoForge.getModifierId((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, operation, event.getSlotContext()), value.doubleValue(), operation)));
            knockbackResistance.forEach((operation, value) -> event.addModifier(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(ElytraslotCompatNeoForge.getModifierId((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, operation, event.getSlotContext()), value.doubleValue(), operation)));
        }
    }

    private static Map<AttributeModifier.Operation, Double> createHashMap() {
        HashMap<AttributeModifier.Operation, Double> map = new HashMap<AttributeModifier.Operation, Double>();
        map.put(AttributeModifier.Operation.ADD_VALUE, 0.0);
        map.put(AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.0);
        map.put(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.0);
        return map;
    }

    private static ResourceLocation getModifierId(Holder<Attribute> attributes, AttributeModifier.Operation operation, SlotContext slot) {
        return ElytraslotCompat.of("elytraslot_" + ElytraslotCompatNeoForge.getAttributeString(attributes) + "_" + operation.toString().toLowerCase() + "_" + ElytraslotCompatNeoForge.getSlotIdentifier(slot));
    }

    private static String getAttributeString(Holder<Attribute> attributes) {
        String id = attributes.getRegisteredName();
        int index = id.indexOf(58);
        if (index != -1 && index + 1 < id.length()) {
            return id.substring(index + 1);
        }
        return "";
    }

    private static String getSlotIdentifier(SlotContext slot) {
        return ElytraslotCompatNeoForge.getCompatIdentifier(slot.identifier()) + "/" + slot.index();
    }

    private static String getCompatIdentifier(String id) {
        int index = id.indexOf(58);
        if (index != -1 && index + 1 < id.length()) {
            return id.substring(index + 1);
        }
        return id;
    }

    private static void calcModifier(Map<AttributeModifier.Operation, Double> map, AttributeModifier modifier) {
        map.replace(modifier.operation(), map.getOrDefault(modifier.operation(), 0.0) + modifier.amount());
    }
}

