/*
 * Decompiled with CFR 0.152.
 */
package me.wheelershigley.tree_in_a_forest.blacklist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Scanner;
import me.wheelershigley.tree_in_a_forest.TreeInAForest;
import me.wheelershigley.tree_in_a_forest.helpers.ConversionsHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11560;

public class Blacklist {
    public static ArrayList<class_11560> configEntryBlacklist = new ArrayList();
    public static ArrayList<String> nameBlacklist = new ArrayList();
    private static final String fileName = "tree_in_a_forest.blacklist".toLowerCase();
    private static final File file = FabricLoader.getInstance().getConfigDir().resolve(fileName).toFile();

    private static boolean createFileIfMissing() {
        if (file.exists() && !file.isDirectory()) {
            return false;
        }
        try {
            file.getParentFile().mkdirs();
            Files.createFile(file.toPath(), new FileAttribute[0]);
            Blacklist.writeFile();
        }
        catch (IOException ioException) {
            TreeInAForest.LOGGER.error("Error making directory.", (Throwable)ioException);
            return false;
        }
        return true;
    }

    private static boolean writeFile() {
        try {
            StringBuilder playerListBuilder = new StringBuilder();
            for (String name : nameBlacklist) {
                playerListBuilder.append(name).append("\r\n");
            }
            for (class_11560 user : configEntryBlacklist) {
                playerListBuilder.append(user.comp_4422().toString().replace("-", "")).append("\r\n");
            }
            PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8);
            writer.write(playerListBuilder.toString());
            writer.close();
        }
        catch (IOException ioException) {
            TreeInAForest.LOGGER.error("Error writing to blacklist.", (Throwable)ioException);
            return false;
        }
        return true;
    }

    public static void initializeBlackList(boolean isOnlineMode) {
        Scanner reader;
        Blacklist.createFileIfMissing();
        try {
            reader = new Scanner(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            TreeInAForest.LOGGER.error("Error reading blacklist.", (Throwable)fileNotFoundException);
            return;
        }
        while (reader.hasNext()) {
            String currentLine = reader.next();
            class_11560 currentEntry = ConversionsHelper.getPlayerConfigEntryFromUUID(ConversionsHelper.getUuidFromTrimmedUuidString(currentLine), isOnlineMode);
            if (currentLine.matches("[0-9a-f]{32}")) {
                if (currentEntry == null) continue;
                configEntryBlacklist.add(currentEntry);
                continue;
            }
            nameBlacklist.add(currentLine);
        }
    }

    public static String[] getBlacklistedNames() {
        ArrayList<String> blacklistedNames = new ArrayList<String>();
        for (String name : nameBlacklist) {
            blacklistedNames.add(name);
        }
        for (class_11560 entry : configEntryBlacklist) {
            String currentName = entry.comp_4423();
            if (currentName == null) continue;
            blacklistedNames.add(currentName);
        }
        return blacklistedNames.toArray(new String[0]);
    }

    public static boolean blacklistUser(class_11560 entry) {
        if (configEntryBlacklist.contains(entry)) {
            return true;
        }
        configEntryBlacklist.add(entry);
        if (Blacklist.createFileIfMissing()) {
            return true;
        }
        return Blacklist.writeFile();
    }

    public static boolean unblacklistUser(class_11560 entry) {
        configEntryBlacklist.remove(entry);
        if (Blacklist.createFileIfMissing()) {
            return true;
        }
        return Blacklist.writeFile();
    }

    public static boolean blacklistUser(String playerName) {
        if (nameBlacklist.contains(playerName)) {
            return true;
        }
        nameBlacklist.add(playerName);
        if (Blacklist.createFileIfMissing()) {
            return true;
        }
        return Blacklist.writeFile();
    }

    public static boolean unblacklistUser(String playerName) {
        nameBlacklist.remove(playerName);
        if (Blacklist.createFileIfMissing()) {
            return true;
        }
        return Blacklist.writeFile();
    }
}

