/*
 * Decompiled with CFR 0.152.
 */
package me.wheelershigley.tree_in_a_forest.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.function.Predicate;
import me.wheelershigley.tree_in_a_forest.TreeInAForest;
import me.wheelershigley.tree_in_a_forest.blacklist.Blacklist;
import me.wheelershigley.tree_in_a_forest.command.BlacklistSuggestionProvider;
import me.wheelershigley.tree_in_a_forest.command.BlacklistedPlayersSuggestionProvider;
import me.wheelershigley.tree_in_a_forest.command.PlayersSuggestionProvider;
import me.wheelershigley.tree_in_a_forest.helpers.ConversionsHelper;
import me.wheelershigley.tree_in_a_forest.helpers.MessagesHelper;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_11560;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Registrator {
    private static final Predicate<class_2168> isServerOrOperator = source -> {
        if (!source.method_43737()) {
            return true;
        }
        class_3222 sourcePlayer = source.method_44023();
        if (sourcePlayer == null) {
            return false;
        }
        MinecraftServer server = sourcePlayer.method_51469().method_8503();
        return server.method_3760().method_14569(sourcePlayer.method_72498());
    };

    private static void sendBlacklistCommandMessages(@NotNull Boolean already, @NotNull Boolean success, @NotNull class_2168 source, @Nullable class_3222 sourcePlayer, @NotNull Boolean usesTellRaws, @NotNull String targetPlayerName, @NotNull String existing_key, @NotNull String success_key, @NotNull String failure_key, @NotNull String console_key) {
        if (already.booleanValue()) {
            MessagesHelper.sendMessageInContext(source, sourcePlayer, existing_key, usesTellRaws, targetPlayerName);
        } else if (success.booleanValue()) {
            MessagesHelper.sendMessageInContext(source, sourcePlayer, success_key, usesTellRaws, targetPlayerName);
            MessagesHelper.sendConsoleInfoTranslatableMessage(console_key, sourcePlayer == null ? "<console>" : "\"" + sourcePlayer.method_5477().getString() + "\"", targetPlayerName);
        } else {
            MessagesHelper.sendMessageInContext(source, sourcePlayer, failure_key, usesTellRaws, targetPlayerName);
        }
    }

    public static void registerCommand() {
        Command addBlacklistCommand = context -> {
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_44023();
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"target");
            class_11560 playerConfig = ConversionsHelper.getProfileFromPlayerName(playerName);
            if (playerConfig != null) {
                boolean already = Blacklist.configEntryBlacklist.contains(playerConfig);
                boolean success = Blacklist.blacklistUser(playerConfig);
                Registrator.sendBlacklistCommandMessages(already, success, (class_2168)context.getSource(), sourcePlayer, false, playerName, "tree_in_a_forest.text.blacklist_player_existing", "tree_in_a_forest.text.blacklist_player", "tree_in_a_forest.text.blacklist_player_failure", "tree_in_a_forest.text.player_blacklisted_player");
                TreeInAForest.updateServerTicking();
                return 0;
            }
            if (playerName != null && !playerName.isEmpty()) {
                boolean already = Blacklist.nameBlacklist.contains(playerName);
                boolean success = Blacklist.blacklistUser(playerName);
                Registrator.sendBlacklistCommandMessages(already, success, (class_2168)context.getSource(), sourcePlayer, false, playerName, "tree_in_a_forest.text.blacklist_player_existing", "tree_in_a_forest.text.blacklist_player", "tree_in_a_forest.text.blacklist_player_failure", "tree_in_a_forest.text.player_blacklisted_player");
                TreeInAForest.updateServerTicking();
                return 0;
            }
            return 1;
        };
        Command removeBlacklistCommand = context -> {
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_44023();
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"target");
            class_11560 playerConfig = ConversionsHelper.getProfileFromPlayerName(playerName);
            if (playerConfig != null) {
                boolean already = !Blacklist.configEntryBlacklist.contains(playerConfig);
                boolean success = Blacklist.unblacklistUser(playerConfig);
                Registrator.sendBlacklistCommandMessages(already, success, (class_2168)context.getSource(), sourcePlayer, false, playerName, "tree_in_a_forest.text.unblacklist_player_existing", "tree_in_a_forest.text.unblacklist_player", "tree_in_a_forest.text.unblacklist_player_failure", "tree_in_a_forest.text.player_unblacklisted_player");
                TreeInAForest.updateServerTicking();
                return 0;
            }
            if (playerName != null && !playerName.isBlank()) {
                boolean already = !Blacklist.nameBlacklist.contains(playerName);
                boolean success = Blacklist.unblacklistUser(playerName);
                Registrator.sendBlacklistCommandMessages(already, success, (class_2168)context.getSource(), sourcePlayer, false, playerName, "tree_in_a_forest.text.unblacklist_player_existing", "tree_in_a_forest.text.unblacklist_player", "tree_in_a_forest.text.unblacklist_player_failure", "tree_in_a_forest.text.player_unblacklisted_player");
                TreeInAForest.updateServerTicking();
                return 0;
            }
            return 1;
        };
        Command listBlacklistCommand = context -> {
            int blacklisted_count = Blacklist.nameBlacklist.size() + Blacklist.configEntryBlacklist.size();
            String namesList = MessagesHelper.getCommaSeperatedBlacklistedNames();
            String key = "";
            switch (blacklisted_count) {
                case 0: {
                    key = "tree_in_a_forest.text.empty_blacklist";
                    break;
                }
                case 1: {
                    key = "tree_in_a_forest.text.single_blacklist";
                    break;
                }
                default: {
                    key = "tree_in_a_forest.text.blacklist";
                }
            }
            MessagesHelper.sendMessageInContext((class_2168)context.getSource(), ((class_2168)context.getSource()).method_44023(), key, false, namesList);
            return 0;
        };
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"treeinaforest").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"sublet", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new BlacklistSuggestionProvider()).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new PlayersSuggestionProvider()).executes(addBlacklistCommand)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new BlacklistedPlayersSuggestionProvider()).executes(removeBlacklistCommand)))).then(class_2170.method_9247((String)"list").executes(listBlacklistCommand)))).requires(isServerOrOperator)));
    }
}

