/*
 * Decompiled with CFR 0.152.
 */
package me.wheelershigley.tree_in_a_forest.helpers;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.wheelershigley.tree_in_a_forest.TreeInAForest;
import me.wheelershigley.tree_in_a_forest.blacklist.Blacklist;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import org.jetbrains.annotations.Nullable;

public class ConversionsHelper {
    private static final StringBuilder uuidBuilder = new StringBuilder();
    private static final String LOOKUP_PROFILE_BASE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";

    public static class_11560 getProfileFromPlayerName(@Nullable String name) {
        if (name == null || !name.matches("^[a-zA-Z0-9_]{2,16}$") || Blacklist.nameBlacklist.contains(name)) {
            return null;
        }
        class_11561 nameToIdCache = TreeInAForest.server.method_73550().comp_4407();
        if (nameToIdCache == null) {
            return null;
        }
        Optional potentialPlayerConfigEntry = nameToIdCache.method_14515(name);
        return potentialPlayerConfigEntry.orElse(null);
    }

    public static UUID getUuidFromTrimmedUuidString(@Nullable String pseudoUUID) {
        if (pseudoUUID == null || !pseudoUUID.matches("^[0-9a-f]{32}$")) {
            return null;
        }
        uuidBuilder.setLength(0);
        uuidBuilder.append(pseudoUUID, 0, 8).append('-').append(pseudoUUID, 8, 12).append('-').append(pseudoUUID, 12, 16).append('-').append(pseudoUUID, 16, 20).append('-').append(pseudoUUID, 20, 32);
        return UUID.fromString(uuidBuilder.toString());
    }

    public static class_11560 getPlayerConfigEntryFromUUID(UUID uuid, boolean isOnlineMode) {
        if (uuid == null) {
            return null;
        }
        if (TreeInAForest.gameProfileCache.containsKey(uuid)) {
            return TreeInAForest.gameProfileCache.get(uuid);
        }
        if (isOnlineMode) {
            try {
                URL url = URI.create(LOOKUP_PROFILE_BASE_URL + uuid.toString()).toURL();
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                String streamContents = br.lines().collect(Collectors.joining("\r\n"));
                JsonObject jsonContents = JsonParser.parseString((String)streamContents).getAsJsonObject();
                String name = jsonContents.get("name").getAsString();
                if (name == null || name.isBlank()) {
                    return null;
                }
                return new class_11560(uuid, name);
            }
            catch (IOException ioException) {
                TreeInAForest.LOGGER.error("An error occurred looking up a player!", (Throwable)ioException);
            }
        }
        return null;
    }
}

