/*
 * Decompiled with CFR 0.152.
 */
package me.guythatlives.gTL_RTP;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.guythatlives.gTL_RTP.GTL_RTP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class DynamicTeleportCommand
extends BukkitCommand {
    Plugin vault = Bukkit.getPluginManager().getPlugin("Vault");
    boolean vaultEnabled = this.vault != null && this.vault.isEnabled();
    private final GTL_RTP plugin;

    public DynamicTeleportCommand(String name, String description, GTL_RTP plugin) {
        super(name);
        this.setDescription(description);
        this.plugin = plugin;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        Plugin vault;
        Location loc;
        double originZ;
        double originY;
        double originX;
        ArrayList<String> biomes;
        ConfigurationSection config;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        FileConfiguration lang = this.plugin.getLang();
        if (lang == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Language file not loaded!");
            return true;
        }
        String actualLabel = label;
        ConfigurationSection configSection = this.plugin.getConfig().getConfigurationSection("commands");
        if (configSection != null) {
            for (String cmdName : configSection.getKeys(false)) {
                List aliases = configSection.getStringList(cmdName + ".aliases");
                if (!aliases.contains(label)) continue;
                actualLabel = cmdName;
                break;
            }
        }
        if (!player.hasPermission("gtl_rtp.command.*") && !player.hasPermission("gtl_rtp.command." + actualLabel)) {
            String noPermMessage = lang.getString("common.no-permission", "&cYou don't have permission to use this command!");
            noPermMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)noPermMessage);
            player.sendMessage(noPermMessage);
            return true;
        }
        String beginningMessage = lang.getString("custom." + actualLabel + ".start");
        if (beginningMessage == null) {
            beginningMessage = lang.getString("common.start");
        }
        if (beginningMessage != null) {
            beginningMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)beginningMessage);
            player.sendMessage(beginningMessage);
        }
        if ((config = this.plugin.getConfig().getConfigurationSection("commands." + actualLabel)) == null) {
            String errorMessage = lang.getString("common.command-not-configured", "&eThis command is not configured.");
            errorMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)errorMessage);
            player.sendMessage(errorMessage);
            return true;
        }
        label = actualLabel;
        List worlds = config.getStringList("worlds");
        if (worlds.isEmpty()) {
            worlds.add(player.getWorld().getName());
        }
        World world = Bukkit.getWorld((String)((String)worlds.get(0)));
        if (worlds.contains(player.getWorld().getName())) {
            world = player.getWorld();
        }
        if (world == null) {
            player.sendMessage("\u00a7cWARNING: GTL_RTP Config has an invalid world setup for command: '/" + actualLabel + "' please reconfigure!");
            player.sendMessage("\u00a7eWorlds that are invalid:" + String.valueOf(worlds) + " defaulting to current player world!");
            world = player.getWorld();
        }
        if ((biomes = config.getStringList("biomes")) == null || biomes.isEmpty()) {
            biomes = new ArrayList<String>();
            biomes.add("all");
        }
        String overrideTP = config.getString("override-tp");
        String originStr = config.getString("origin", "0,64,0");
        if (originStr.equalsIgnoreCase("player")) {
            originX = player.getLocation().getX();
            originY = player.getLocation().getY();
            originZ = player.getLocation().getZ();
        } else {
            String[] parts = originStr.split(",");
            if (parts.length < 3) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid origin format in config! Expected: x,y,z");
                return true;
            }
            originX = Double.parseDouble(parts[0].trim());
            originY = Double.parseDouble(parts[1].trim());
            originZ = Double.parseDouble(parts[2].trim());
        }
        String ymargin = config.getString("y-margin", "top");
        if (ymargin.equals("force-top")) {
            ymargin = "top";
        } else if (ymargin.equals("force-bottom")) {
            ymargin = "bottom";
        } else {
            if (world.getEnvironment() == World.Environment.NETHER) {
                ymargin = "bottom";
            }
            if (world.getEnvironment() == World.Environment.THE_END) {
                ymargin = "top";
            }
        }
        String type = config.getString("type", "random");
        if (type.equalsIgnoreCase("fixed")) {
            loc = new Location(world, originX, originY, originZ);
        } else {
            int minRadius = config.getInt("min-radius", 10);
            int maxRadius = config.getInt("max-radius", 50);
            Random rand = new Random();
            boolean allowAllBiomes = biomes.contains("all");
            loc = null;
            int attempts = 0;
            int maxAttempts = 100;
            while (attempts < maxAttempts) {
                double z;
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double radius = (double)minRadius + rand.nextDouble() * (double)(maxRadius - minRadius);
                double x = originX + Math.cos(angle) * radius;
                Chunk chunk = world.getChunkAt((int)x >> 4, (int)(z = originZ + Math.sin(angle) * radius) >> 4);
                if (!chunk.isLoaded()) {
                    chunk.load(true);
                }
                if (ymargin.equalsIgnoreCase("bottom")) {
                    y = world.getMinHeight() + 1;
                    for (int checkY = world.getMinHeight() + 1; checkY < world.getMaxHeight() - 1; ++checkY) {
                        if (!world.getBlockAt((int)x, checkY - 1, (int)z).getType().isSolid() || !world.getBlockAt((int)x, checkY, (int)z).getType().isAir() || !world.getBlockAt((int)x, checkY + 1, (int)z).getType().isAir()) continue;
                        y = checkY;
                        break;
                    }
                    loc = new Location(world, x, (double)y, z);
                } else if (ymargin.equalsIgnoreCase("top")) {
                    y = world.getHighestBlockYAt((int)x, (int)z) + 1;
                    loc = new Location(world, x, (double)y, z);
                } else {
                    int minY = config.getInt("min-y", -64);
                    int maxY = config.getInt("max-y", 64);
                    int y = minY;
                    boolean foundCave = false;
                    int blocksChecked = 0;
                    for (int checkY = minY + 1; checkY < maxY - 1; ++checkY) {
                        Material below = world.getBlockAt((int)x, checkY - 1, (int)z).getType();
                        Material feet = world.getBlockAt((int)x, checkY, (int)z).getType();
                        Material head = world.getBlockAt((int)x, checkY + 1, (int)z).getType();
                        ++blocksChecked;
                        if (!below.isSolid() || !feet.isAir() || !head.isAir()) continue;
                        y = checkY;
                        foundCave = true;
                        break;
                    }
                    if (!foundCave) {
                        ++attempts;
                        continue;
                    }
                    loc = new Location(world, x, (double)y, z);
                }
                if (allowAllBiomes) break;
                String biomeName = loc.getBlock().getBiome().getKey().getKey();
                boolean biomeMatches = biomes.stream().anyMatch(b -> b.equalsIgnoreCase(biomeName));
                if (biomeMatches) break;
                ++attempts;
            }
            if (attempts >= maxAttempts) {
                String maxAttemptsError = lang.getString("common.max-attempt-error", "&cCould not find a valid location!");
                maxAttemptsError = ChatColor.translateAlternateColorCodes((char)'&', (String)maxAttemptsError);
                player.sendMessage(maxAttemptsError);
                return true;
            }
        }
        boolean canTeleport = true;
        double cost = config.getDouble("cost", 0.0);
        if (cost < 0.0) {
            cost = 0.0;
        }
        if (player.hasPermission("gtl_rtp.bypass.cost") || player.hasPermission("gtl_rtp.bypass.*")) {
            cost = 0.0;
        }
        if ((vault = Bukkit.getPluginManager().getPlugin("Vault")) != null && cost > 0.0) {
            try {
                RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Class.forName("net.milkbowl.vault.economy.Economy"));
                if (rsp == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No economy plugin detected! Install EssentialsX or another economy provider.");
                    return true;
                }
                Object econ = rsp.getProvider();
                Method hasMethod = econ.getClass().getMethod("has", OfflinePlayer.class, Double.TYPE);
                Method withdrawMethod = econ.getClass().getMethod("withdrawPlayer", OfflinePlayer.class, Double.TYPE);
                boolean canAfford = (Boolean)hasMethod.invoke(econ, player, cost);
                if (!canAfford) {
                    String insufficientFundsMessage = lang.getString("custom." + actualLabel + ".eco-insufficient-funds");
                    if (insufficientFundsMessage == null) {
                        insufficientFundsMessage = lang.getString("common.eco-insufficient-funds", "\u00a7eYou need " + cost + " to run this command!");
                    }
                    if (!insufficientFundsMessage.equalsIgnoreCase("none")) {
                        insufficientFundsMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)insufficientFundsMessage);
                        insufficientFundsMessage = insufficientFundsMessage.replace("{player}", player.getName());
                        insufficientFundsMessage = insufficientFundsMessage.replace("{cost}", String.valueOf(cost));
                        insufficientFundsMessage = insufficientFundsMessage.replace("{amount}", String.valueOf(cost));
                        balance = 0.0;
                        try {
                            Method getBalanceMethod = econ.getClass().getMethod("getBalance", Player.class);
                            balance = (Double)getBalanceMethod.invoke(econ, player);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Failed to get player balance");
                        }
                        insufficientFundsMessage = insufficientFundsMessage.replace("{balance}", String.valueOf(balance));
                        player.sendMessage(insufficientFundsMessage);
                    }
                } else {
                    String chargeMessage = lang.getString("custom." + actualLabel + ".eco-charged");
                    if (chargeMessage == null) {
                        chargeMessage = lang.getString("common.eco-charged", "&eYou have been charged: " + cost);
                    }
                    if (!chargeMessage.equalsIgnoreCase("none")) {
                        chargeMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)chargeMessage);
                        chargeMessage = chargeMessage.replace("{player}", player.getName());
                        chargeMessage = chargeMessage.replace("{cost}", String.valueOf(cost));
                        chargeMessage = chargeMessage.replace("{amount}", String.valueOf(cost));
                        balance = 0.0;
                        try {
                            Method getBalanceMethod = econ.getClass().getMethod("getBalance", Player.class);
                            balance = (Double)getBalanceMethod.invoke(econ, player);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Failed to get player balance");
                        }
                        chargeMessage = chargeMessage.replace("{balance}", String.valueOf(balance));
                        player.sendMessage(chargeMessage);
                    }
                }
                withdrawMethod.invoke(econ, player, cost);
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cVault error: " + e.getMessage());
                e.printStackTrace();
                String vaultErrorMessage = lang.getString("common.no-vault", "&cEconomy system error!");
                vaultErrorMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)vaultErrorMessage);
                player.sendMessage(vaultErrorMessage);
                return true;
            }
        }
        if (!player.getWorld().equals((Object)world)) {
            player.teleport(new Location(world, loc.getX() + 0.5, loc.getY(), loc.getZ() + 0.5));
        } else {
            player.teleport(new Location(world, loc.getX() + 0.5, loc.getY(), loc.getZ() + 0.5));
        }
        List onTpCommands = config.getStringList("on-tp-commands");
        if (!onTpCommands.isEmpty()) {
            Location finalLoc = loc;
            World finalWorld = world;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                for (String cmd : onTpCommands) {
                    String processed = this.processCommand(cmd, finalLoc, player, finalWorld);
                    if (processed.startsWith("setblock ") || processed.startsWith("fill ")) {
                        String[] parts = processed.split(" ");
                        if (parts.length < 5) continue;
                        int x = Integer.parseInt(parts[1]);
                        int y = Integer.parseInt(parts[2]);
                        int z = Integer.parseInt(parts[3]);
                        String blockType = parts[4];
                        finalWorld.getBlockAt(x, y, z).setType(Material.valueOf((String)blockType.toUpperCase()));
                        continue;
                    }
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processed);
                }
            }, 20L);
        }
        if (type.equalsIgnoreCase("fixed")) {
            String message = lang.getString("custom." + actualLabel + ".success");
            if (message == null) {
                message = lang.getString("common.tp", "&8Player has been teleported.");
            }
            message = message.replace("{cost}", String.valueOf(cost));
            message = message.replace("{x}", String.valueOf(Math.round(loc.getX())));
            message = message.replace("{y}", String.valueOf(Math.round(loc.getY())));
            message = message.replace("{z}", String.valueOf(Math.round(loc.getZ())));
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            player.sendMessage(message);
        }
        if (type.equalsIgnoreCase("random")) {
            String message = lang.getString("custom." + actualLabel + ".success");
            if (message == null) {
                message = lang.getString("common.rtp", "&8Player has been randomly teleported.");
            }
            message = message.replace("{cost}", String.valueOf(cost));
            message = message.replace("{x}", String.valueOf(Math.round(loc.getX())));
            message = message.replace("{y}", String.valueOf(Math.round(loc.getY())));
            message = message.replace("{z}", String.valueOf(Math.round(loc.getZ())));
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            player.sendMessage(message);
        }
        return true;
    }

    private String processCommand(String command, Location loc, Player player, World world) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        command = command.replace("{player}", player.getName());
        command = command.replace("{world}", world.getName());
        command = command.replace("{x}", String.valueOf(x));
        command = command.replace("{y}", String.valueOf(y));
        command = command.replace("{z}", String.valueOf(z));
        command = this.replaceWithMath(command, "x", x);
        command = this.replaceWithMath(command, "y", y);
        command = this.replaceWithMath(command, "z", z);
        return command;
    }

    private String replaceWithMath(String command, String var, int value) {
        Pattern pattern = Pattern.compile("\\{" + var + "([+\\-*/])(\\d+)\\}");
        Matcher matcher = pattern.matcher(command);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String operator = matcher.group(1);
            int operand = Integer.parseInt(matcher.group(2));
            int finalValue = value;
            switch (operator) {
                case "+": {
                    finalValue = value + operand;
                    break;
                }
                case "-": {
                    finalValue = value - operand;
                    break;
                }
                case "*": {
                    finalValue = value * operand;
                    break;
                }
                case "/": {
                    finalValue = value / operand;
                }
            }
            matcher.appendReplacement(result, String.valueOf(finalValue));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

