/*
 * Decompiled with CFR 0.152.
 */
package me.guythatlives.gTL_RTP;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import me.guythatlives.gTL_RTP.GTL_RTP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class DynamicTeleportCommand
extends BukkitCommand {
    Plugin vault = Bukkit.getPluginManager().getPlugin("Vault");
    boolean vaultEnabled = this.vault != null && this.vault.isEnabled();
    private final GTL_RTP plugin;

    public DynamicTeleportCommand(String name, String description, GTL_RTP plugin) {
        super(name);
        this.setDescription(description);
        this.plugin = plugin;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        double cost;
        Location loc;
        String type;
        String actualLabel;
        FileConfiguration lang;
        Player player;
        block29: {
            Plugin vault;
            double originZ;
            double originY;
            double originX;
            ConfigurationSection config;
            String beginningMessage;
            if (!(sender instanceof Player)) {
                sender.sendMessage("Only players can use this command!");
                return true;
            }
            player = (Player)sender;
            lang = this.plugin.getLang();
            if (lang == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error: Language file not loaded! Please check your plugin configuration.");
                return true;
            }
            actualLabel = label;
            ConfigurationSection configSection = this.plugin.getConfig().getConfigurationSection("commands");
            if (configSection != null) {
                for (String cmdName : configSection.getKeys(false)) {
                    List aliases = configSection.getStringList(cmdName + ".aliases");
                    if (!aliases.contains(label)) continue;
                    actualLabel = cmdName;
                    break;
                }
            }
            if ((beginningMessage = lang.getString("custom." + actualLabel + ".start")) == null) {
                beginningMessage = lang.getString("common.start");
            }
            if (beginningMessage != null) {
                beginningMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)beginningMessage);
                player.sendMessage(beginningMessage);
            }
            if ((config = this.plugin.getConfig().getConfigurationSection("commands." + actualLabel)) == null) {
                String errorMessage = lang.getString("common.command-not-configured", "&eThis command is not configured.");
                errorMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)errorMessage);
                player.sendMessage(errorMessage);
                return true;
            }
            List worlds = config.getStringList("worlds");
            if (worlds.isEmpty()) {
                worlds.add(player.getWorld().getName());
            }
            World world = Bukkit.getWorld((String)((String)worlds.get(new Random().nextInt(worlds.size()))));
            if (worlds.contains(player.getWorld().getName())) {
                world = player.getWorld();
            }
            if (world == null) {
                player.sendMessage("\u00a7cWARNING: GTL_RTP Config has an invalid world setup for command: '/" + actualLabel + "' please reconfigure!");
                player.sendMessage("\u00a7eWorlds that are invalid:" + String.valueOf(worlds) + " defaulting to current player world!");
                world = player.getWorld();
            }
            List biomes = config.getStringList("biomes");
            String overrideTP = config.getString("override-tp");
            String originStr = config.getString("origin", "0,64,0");
            if (originStr.equalsIgnoreCase("player")) {
                originX = player.getLocation().getX();
                originY = player.getLocation().getY();
                originZ = player.getLocation().getZ();
            } else {
                String[] parts = originStr.split(",");
                originX = Double.parseDouble(parts[0]);
                originY = Double.parseDouble(parts[1]);
                originZ = Double.parseDouble(parts[2]);
            }
            type = config.getString("type", "random");
            if (type.equalsIgnoreCase("fixed")) {
                loc = new Location(world, originX, originY, originZ);
            } else {
                int attempts;
                int minRadius = config.getInt("min-radius", 10);
                int maxRadius = config.getInt("max-radius", 50);
                Random rand = new Random();
                boolean allowAllBiomes = biomes.contains("all");
                loc = null;
                int maxAttempts = 100;
                for (attempts = 0; attempts < maxAttempts; ++attempts) {
                    double angle = rand.nextDouble() * 2.0 * Math.PI;
                    double radius = (double)minRadius + rand.nextDouble() * (double)(maxRadius - minRadius);
                    double x = originX + Math.cos(angle) * radius;
                    double z = originZ + Math.sin(angle) * radius;
                    int y = world.getHighestBlockYAt((int)x, (int)z) + 1;
                    loc = new Location(world, x, (double)y, z);
                    if (allowAllBiomes) break;
                    String biomeName = loc.getBlock().getBiome().getKey().getKey();
                    boolean biomeMatches = biomes.stream().anyMatch(b -> b.equalsIgnoreCase(biomeName));
                    if (biomeMatches) break;
                }
                if (attempts >= maxAttempts) {
                    String maxAttemptsError = lang.getString("common.max-attempt-error", "&cCould not find a valid location!");
                    maxAttemptsError = ChatColor.translateAlternateColorCodes((char)'&', (String)maxAttemptsError);
                    player.sendMessage(maxAttemptsError);
                    return true;
                }
            }
            boolean canTeleport = true;
            cost = config.getDouble("cost", 0.0);
            if (cost < 0.0) {
                cost = 0.0;
            }
            if ((vault = Bukkit.getPluginManager().getPlugin("Vault")) != null) {
                try {
                    RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Class.forName("net.milkbowl.vault.economy.Economy"));
                    if (rsp == null) {
                        throw new IllegalStateException("No economy provider registered");
                    }
                    Object econ = rsp.getProvider();
                    Method hasMethod = econ.getClass().getMethod("has", Player.class, Double.TYPE);
                    Method withdrawMethod = econ.getClass().getMethod("withdrawPlayer", Player.class, Double.TYPE);
                    boolean canAfford = (Boolean)hasMethod.invoke(econ, player, cost);
                    if (!canAfford) {
                        canTeleport = false;
                    } else {
                        withdrawMethod.invoke(econ, player, cost);
                    }
                }
                catch (Exception ignored) {
                    if (!(cost > 0.0)) break block29;
                    String vaultErrorMessage = lang.getString("common.no-vault");
                    vaultErrorMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)vaultErrorMessage);
                    cost = 0.0;
                    player.sendMessage(vaultErrorMessage);
                }
            }
        }
        if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("essentials:tppos " + player.getName() + " " + loc.getX() + " " + loc.getY() + " " + loc.getZ()));
        } else {
            player.teleport(loc);
        }
        if (type.equalsIgnoreCase("fixed")) {
            String message = lang.getString("custom." + actualLabel + ".success");
            if (message == null) {
                message = lang.getString("common.tp", "&8Player has been teleported.");
            }
            message = message.replace("{cost}", String.valueOf(cost));
            message = message.replace("{x}", String.valueOf(Math.round(loc.getX())));
            message = message.replace("{y}", String.valueOf(Math.round(loc.getY())));
            message = message.replace("{z}", String.valueOf(Math.round(loc.getZ())));
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            player.sendMessage(message);
        }
        if (type.equalsIgnoreCase("random")) {
            String message = lang.getString("custom." + actualLabel + ".success");
            if (message == null) {
                message = lang.getString("common.rtp", "&8Player has been randomly teleported.");
            }
            message = message.replace("{cost}", String.valueOf(cost));
            message = message.replace("{x}", String.valueOf(Math.round(loc.getX())));
            message = message.replace("{y}", String.valueOf(Math.round(loc.getY())));
            message = message.replace("{z}", String.valueOf(Math.round(loc.getZ())));
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            player.sendMessage(message);
        }
        return true;
    }
}

