/*
 * Decompiled with CFR 0.152.
 */
package me.guythatlives.gTL_RTP;

import java.io.File;
import java.util.List;
import me.guythatlives.gTL_RTP.DynamicTeleportCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class GTL_RTP
extends JavaPlugin
implements CommandExecutor {
    private FileConfiguration langConfig;
    private File langFile;

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveResource("lang.yml", false);
        this.loadLang();
        this.getCommand("gtl_rtp").setExecutor((CommandExecutor)this);
        this.registerDynamicCommands();
        this.getLogger().info("GTL_RTP enabled!");
    }

    private void registerDynamicCommands() {
        ConfigurationSection section = this.getConfig().getConfigurationSection("commands");
        if (section == null) {
            return;
        }
        CommandMap commandMap = Bukkit.getServer().getCommandMap();
        for (String cmdName : section.getKeys(false)) {
            String description = section.getString(cmdName + ".description", "No description");
            DynamicTeleportCommand command = new DynamicTeleportCommand(cmdName, description, this);
            commandMap.register("gtl_rtp", (Command)command);
            List aliases = section.getStringList(cmdName + ".aliases");
            for (String alias : aliases) {
                commandMap.register(alias, "gtl_rtp", (Command)command);
            }
            this.getLogger().info("Registered command: /" + cmdName + " with " + aliases.size() + " aliases");
        }
    }

    public void loadLang() {
        this.langFile = new File(this.getDataFolder(), "lang.yml");
        this.langConfig = YamlConfiguration.loadConfiguration((File)this.langFile);
    }

    public FileConfiguration getLang() {
        return this.langConfig;
    }

    public void reload() {
        this.reloadConfig();
        this.saveResource("lang.yml", false);
        this.loadLang();
        this.registerDynamicCommands();
        this.getLogger().info("GTL_RTP config and commands reloaded!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            this.reload();
            sender.sendMessage("\u00a7aGTL_RTP reloaded!");
            return true;
        }
        sender.sendMessage("\u00a7eUsage: /gtl_rtp reload");
        return true;
    }

    public void onDisable() {
        this.getLogger().info("GuyThatLives: RTP Plugin has left!");
    }

    public void reloadLang() {
        this.loadLang();
    }
}

