/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.file;

import com.google.common.base.Preconditions;
import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.file.StorageFile;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class DBFile
extends StorageFile {
    private static boolean loaded = false;
    private final Thread mainThread;
    private final ExecutorService dbThread;

    public DBFile(String fileName) {
        this(DamageIndicator.INSTANCE.getDataFolder().getPath(), fileName);
    }

    public DBFile(String directory, String fileName) {
        this(directory, fileName, null, false);
    }

    public DBFile(String directory, String fileName, Integer fileVersion, boolean resetFile) {
        super(directory, fileName, fileVersion, resetFile);
        try {
            Class.forName("org.sqlite.JDBC");
            loaded = true;
        }
        catch (ClassNotFoundException e) {
            DamageIndicator.INSTANCE.getLogger().severe("Failed to initialize database! Toggles will not persist through server restarts.");
        }
        this.mainThread = Thread.currentThread();
        this.dbThread = Executors.newSingleThreadExecutor();
        if (loaded && !this.file.exists()) {
            this.runOnDbThread(this::createTables);
        }
    }

    private static Connection connect() {
        if (!loaded) {
            return null;
        }
        String url = "jdbc:sqlite:" + DamageIndicator.INSTANCE.getDataFolder() + File.separator + "database.db";
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    private void sendStatement(String sql) {
        this.sendPreparedStatement(sql, new Object[0]);
    }

    private void sendPreparedStatement(String sql, Object ... parameters) {
        this.sendQueryStatement(sql, null, parameters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object sendQueryStatement(String sql, String query, Object ... parameters) {
        Object result = null;
        Preconditions.checkState((Thread.currentThread() != this.mainThread ? 1 : 0) != 0, (Object)"Database operations must be run on the database thread!");
        Preconditions.checkState((!this.dbThread.isShutdown() && !this.dbThread.isTerminated() ? 1 : 0) != 0, (Object)"Database thread is not running! Database operations cannot be performed after shutdown is called.");
        try (Connection conn = DBFile.connect();){
            if (conn == null) {
                Object var7_8 = null;
                return var7_8;
            }
            if ((parameters == null || parameters.length == 0) && query == null) {
                Statement statement = conn.createStatement();
                statement.execute(sql);
                return result;
            }
            PreparedStatement ps = conn.prepareStatement(sql);
            for (int i = 0; i < parameters.length; ++i) {
                ps.setObject(i + 1, parameters[i]);
            }
            if (query == null) {
                ps.execute();
                return result;
            }
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return result;
            result = rs.getObject(query);
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void shutdown() {
        if (this.dbThread.isShutdown() || this.dbThread.isTerminated()) {
            return;
        }
        this.dbThread.shutdown();
        try {
            if (!this.dbThread.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.dbThread.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.dbThread.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void runOnDbThread(Runnable runnable) {
        this.dbThread.submit(runnable);
    }

    public void createTables() {
        String sql = "CREATE TABLE IF NOT EXISTS damageindicator (id integer PRIMARY KEY AUTOINCREMENT, player text NOT NULL UNIQUE, toggle tinyint NOT NULL);";
        this.sendStatement(sql);
    }

    public void initData(UUID uuid) {
        String sql = "INSERT OR IGNORE INTO damageindicator(player, toggle) VALUES(?, ?)";
        this.sendPreparedStatement(sql, uuid, 1);
    }

    public boolean getToggleStatus(UUID uuid) {
        this.initData(uuid);
        boolean status = false;
        String sql = "SELECT toggle FROM damageindicator WHERE player = ?";
        Object toggleInt = this.sendQueryStatement(sql, "toggle", uuid);
        if (toggleInt instanceof Integer) {
            status = (Integer)toggleInt == 1;
        }
        return status;
    }

    public void setToggleStatus(UUID uuid, boolean status) {
        this.initData(uuid);
        int toggleInt = status ? 1 : 0;
        String sql = "UPDATE damageindicator SET toggle = ? WHERE player = ?";
        this.sendPreparedStatement(sql, toggleInt, uuid);
    }
}

