/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib;

import com.zenya.damageindicator.libs.net.insprill.xenlib.MinecraftVersion;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColourUtils {
    public static final Pattern hexPattern = Pattern.compile("#[a-fA-F\\d]{6}");
    public static final Pattern formattedHexPattern = Pattern.compile("[?:{<&]?#[a-fA-F\\d]{6}[}>]?");

    public static String format(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (MinecraftVersion.isAtLeast(MinecraftVersion.v1_16_0)) {
            Matcher formattedMatcher = formattedHexPattern.matcher(string);
            while (formattedMatcher.find()) {
                String hex = formattedMatcher.group();
                Matcher hexMatcher = hexPattern.matcher(hex);
                if (!hexMatcher.find()) continue;
                string = string.replace(formattedMatcher.group(), ChatColor.of((String)hexMatcher.group()).toString());
                formattedMatcher.reset(string);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    @Nullable
    public static List<String> format(@Nullable List<String> strings) {
        if (strings == null) {
            return strings;
        }
        strings.replaceAll(ColourUtils::format);
        return strings;
    }

    @Nullable
    public static List<String> stripColor(@Nullable List<String> strings) {
        if (strings == null) {
            return strings;
        }
        strings.replaceAll(ChatColor::stripColor);
        return strings;
    }

    public static void removeLineIgnoreColour(@NotNull List<String> source, @Nullable String forRemoval) {
        if (forRemoval == null || forRemoval.isEmpty()) {
            return;
        }
        source.removeIf(line -> ChatColor.stripColor((String)line).equals(ChatColor.stripColor((String)forRemoval)));
    }

    public static void removeLinesIgnoreColour(@NotNull List<String> source, @Nullable List<String> forRemoval) {
        if (forRemoval == null) {
            return;
        }
        ColourUtils.stripColor(forRemoval);
        source.removeIf(line -> forRemoval.contains(ChatColor.stripColor((String)line)));
    }

    private ColourUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

