/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j;

import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.Params;
import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.Response;
import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.exception.HostNotFoundException;
import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.exception.InvalidURLException;
import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.exception.TimeoutException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class Fetch {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static Response fetch(String url) {
        return Fetch.fetch(url, new Params());
    }

    public static Response fetch(String url, Params params) {
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
        }
        catch (IOException e) {
            throw new InvalidURLException(e);
        }
        for (Map.Entry<String, String> header : params.getHeaders().entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        conn.setRequestMethod(params.getMethod().name());
        conn.setInstanceFollowRedirects(params.isFollowRedirects());
        conn.setConnectTimeout(params.getConnectionTimeout());
        conn.setReadTimeout(params.getReadTimeout());
        conn.setUseCaches(params.isUseCaches());
        try {
            if (params.getBody() != null) {
                conn.setDoOutput(true);
                conn.getOutputStream().write(params.getBody());
            }
            conn.connect();
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException(e);
        }
        catch (IOException e) {
            throw new HostNotFoundException(e);
        }
        return new Response(conn);
    }

    private Fetch() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

