/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j;

import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.Fetch;
import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.exception.InvalidMethodException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class Params {
    private static boolean defaultFollowRedirects = true;
    private static boolean defaultUseCaches = true;
    private static int defaultConnectionTimeout = 60000;
    private static int defaultReadTimeout = 60000;
    @NonNull
    private static Map<String, String> defaultHeaders = new HashMap<String, String>();
    private Method method = Method.GET;
    private final Map<String, String> headers = new HashMap<String, String>(defaultHeaders);
    private boolean followRedirects = defaultFollowRedirects;
    private boolean useCaches = defaultUseCaches;
    private int connectionTimeout = defaultConnectionTimeout;
    private int readTimeout = defaultReadTimeout;
    private byte[] body;

    public static Params params() {
        return new Params();
    }

    public Params method(Method method) {
        this.method = method;
        return this;
    }

    @Deprecated
    public Params method(String method) {
        this.method = Method.fromName(method);
        if (this.method == null) {
            throw new InvalidMethodException(method);
        }
        return this;
    }

    public Params header(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Params contentType(ContentType contentType) {
        this.contentType(contentType.getName());
        return this;
    }

    public Params contentType(String contentType) {
        this.header("Content-Type", contentType);
        return this;
    }

    public Params userAgent(String userAgent) {
        this.header("User-Agent", userAgent);
        return this;
    }

    public Params followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public Params useCaches(boolean useCaches) {
        this.useCaches = useCaches;
        return this;
    }

    public Params connectionTimeout(int timeoutMillis) {
        this.connectionTimeout = timeoutMillis;
        return this;
    }

    public Params readTimeout(int timeoutMillis) {
        this.readTimeout = timeoutMillis;
        return this;
    }

    public Params timeout(int timeoutMillis) {
        this.connectionTimeout(timeoutMillis);
        this.readTimeout(timeoutMillis);
        return this;
    }

    public Params body(String body) {
        return this.body(body, Fetch.DEFAULT_CHARSET);
    }

    public Params body(String body, Charset charset) {
        this.body = body.getBytes(charset);
        return this;
    }

    public Params body(byte[] body) {
        this.body = body;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public byte[] getBody() {
        return this.body;
    }

    public static void setDefaultFollowRedirects(boolean defaultFollowRedirects) {
        Params.defaultFollowRedirects = defaultFollowRedirects;
    }

    public static void setDefaultUseCaches(boolean defaultUseCaches) {
        Params.defaultUseCaches = defaultUseCaches;
    }

    public static void setDefaultConnectionTimeout(int defaultConnectionTimeout) {
        Params.defaultConnectionTimeout = defaultConnectionTimeout;
    }

    public static void setDefaultReadTimeout(int defaultReadTimeout) {
        Params.defaultReadTimeout = defaultReadTimeout;
    }

    public static void setDefaultHeaders(@NonNull Map<String, String> defaultHeaders) {
        if (defaultHeaders == null) {
            throw new NullPointerException("defaultHeaders is marked non-null but is null");
        }
        Params.defaultHeaders = defaultHeaders;
    }

    public static enum Method {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        TRACE;


        public static Method fromName(String name) {
            try {
                return Method.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
    }

    public static enum ContentType {
        AAC("audio/aac"),
        AVIF("aimage/avif"),
        BINARY("application/octet-stream"),
        BZIP("application/x-bzip"),
        BZIP2("application/x-bzip2"),
        CSS("text/css"),
        GIF("image/gif"),
        GZIP("application/gzip"),
        HTML("text/html"),
        JAR("application/java-archive"),
        JAVASCRIPT("text/javascript"),
        JPEG("image/jpeg"),
        JSON("application/json"),
        MP3("audio/mpeg"),
        MP4("video/mp4"),
        OGG("application/ogg"),
        PDF("application/pdf"),
        PNG("image/png"),
        RAR("application/vnd.rar"),
        SVG("image/svg+xml"),
        TEXT("text/plain"),
        WAV("audio/wav"),
        WEBP("image/webp"),
        XML("application/xml"),
        ZIP("application/zip");

        private final String name;

        private ContentType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

