/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j;

import com.zenya.damageindicator.libs.net.insprill.xenlib.libs.net.insprill.fetch4j.Fetch;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class Response {
    private static final byte[] EMPTY_RESPONSE_BODY = new byte[0];
    private final HttpURLConnection conn;
    private final byte[] responseBody;

    protected Response(HttpURLConnection conn) {
        this.conn = conn;
        try (InputStream body = this.getStatus() >= 400 ? conn.getErrorStream() : conn.getInputStream();){
            int nRead;
            if (body == null) {
                this.responseBody = EMPTY_RESPONSE_BODY;
                return;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((nRead = body.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            this.responseBody = buffer.toByteArray();
        }
    }

    public boolean ok() {
        return this.getStatus() >= 200 && this.getStatus() < 300;
    }

    public int getStatus() {
        return this.conn.getResponseCode();
    }

    public String getStatusText() {
        return this.conn.getResponseMessage();
    }

    public boolean hasHeader(String name) {
        return this.getHeader(name) != null;
    }

    public String getHeader(String name) {
        return this.conn.getHeaderField(name);
    }

    public Map<String, List<String>> getHeaders() {
        return this.conn.getHeaderFields();
    }

    public String getContentType() {
        return this.conn.getContentType().split(";")[0];
    }

    public String getContentEncoding() {
        String encoding = this.conn.getContentEncoding();
        if (encoding != null) {
            return encoding;
        }
        String contentType = this.conn.getContentType();
        if (contentType == null) {
            return Fetch.DEFAULT_CHARSET.displayName();
        }
        for (String s : contentType.split(";")) {
            String[] data = s.trim().split("=");
            if (!data[0].equalsIgnoreCase("charset")) continue;
            return data[1];
        }
        return null;
    }

    public long getContentLength() {
        return this.conn.getContentLengthLong() == -1L ? (long)this.responseBody.length : this.conn.getContentLengthLong();
    }

    public String getBody() {
        String encoding = this.getContentEncoding() != null && Charset.isSupported(this.getContentEncoding()) ? this.getContentEncoding() : Fetch.DEFAULT_CHARSET.name();
        return this.getBody(Charset.forName(encoding));
    }

    public String getBody(Charset charset) {
        return new String(this.responseBody, charset);
    }

    public byte[] getBodyBytes() {
        byte[] resBody = new byte[this.responseBody.length];
        System.arraycopy(this.responseBody, 0, resBody, 0, this.responseBody.length);
        return resBody;
    }

    public void disconnect() {
        this.conn.disconnect();
    }

    public String toString() {
        return "Response={headers=" + this.conn.getHeaderFields() + ", body=" + this.getBody() + "}";
    }
}

