/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.xenlib.localization;

import com.zenya.damageindicator.libs.net.insprill.xenlib.XenLib;
import com.zenya.damageindicator.libs.net.insprill.xenlib.files.YamlFile;
import com.zenya.damageindicator.libs.net.insprill.xenlib.files.YamlFolder;
import java.io.InputStreamReader;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class Lang {
    private static final String PLACEHOLDER_SEPARATOR = ";";
    private static final String DEFAULT_LOCALE = "en-us";
    private static YamlFile defaultFile;

    public static void initConfig() {
        defaultFile = new YamlFile(new InputStreamReader(XenLib.getPlugin().getResource("locale/en-us.yml"))).setModifiable(false);
    }

    public static String get(String node, String ... placeholders) {
        YamlFile config = Lang.getLocaleConfig();
        String line = config.getString(node, defaultFile.getString(node));
        if (line == null) {
            XenLib.getPlugin().getLogger().severe("Tried to send locale message '" + node + "' but it doesn't exist! Please contact author(s) " + XenLib.getPlugin().getDescription().getAuthors() + " of " + XenLib.getPlugin().getName() + ".");
            return null;
        }
        line = line.replace("%p%", config.getString("prefix", defaultFile.getString("prefix")));
        for (String placeholder : placeholders) {
            String[] data = placeholder.split(PLACEHOLDER_SEPARATOR);
            if (data.length < 2) {
                XenLib.getPlugin().getLogger().warning("Placeholder '" + placeholder + "' for locale message '" + node + "' is invalid! Please contact author(s) " + XenLib.getPlugin().getDescription().getAuthors() + " of " + XenLib.getPlugin().getName() + ".");
                continue;
            }
            line = line.replace(data[0], data[1]);
        }
        return line;
    }

    public static void send(CommandSender sender, String node, String ... placeholders) {
        String line = Lang.get(node, placeholders);
        if (line == null) {
            return;
        }
        sender.sendMessage(Lang.get(node, placeholders));
    }

    @NotNull
    public static YamlFile getLocaleConfig() {
        String selectedLocale = YamlFile.CONFIG.getString("language", DEFAULT_LOCALE);
        YamlFile config = YamlFolder.LOCALE.getDataFile(selectedLocale);
        if (config == null) {
            config = YamlFolder.LOCALE.contains(DEFAULT_LOCALE) ? YamlFolder.LOCALE.getDataFile(DEFAULT_LOCALE) : defaultFile;
            XenLib.getPlugin().getLogger().severe("Locale file '" + selectedLocale + "' could not be found! Defaulting to " + DEFAULT_LOCALE + ".");
        }
        return config;
    }

    private Lang() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

