/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.nms.v1_20_5;

import com.zenya.damageindicator.nms.Hologram;
import com.zenya.damageindicator.nms.ProtocolNMS;
import java.util.List;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ProtocolNMSImpl
implements ProtocolNMS {
    @Override
    public Hologram getHologram(LivingEntity ent, Location loc, String text) {
        return new HologramImpl(ent, loc, text);
    }

    public static class HologramImpl
    implements Hologram {
        private final EntityArmorStand armorStand;
        private final LivingEntity entity;
        private final PlayerChunkMap.EntityTracker tracker;

        public HologramImpl(LivingEntity entity, Location loc, String text) {
            this.entity = entity;
            WorldServer world = ((CraftWorld)loc.getWorld()).getHandle();
            this.armorStand = new EntityArmorStand((World)world, loc.getX(), loc.getY(), loc.getZ());
            this.armorStand.k(true);
            this.armorStand.u(true);
            this.armorStand.t(true);
            this.armorStand.f(true);
            this.armorStand.b((IChatBaseComponent)IChatMutableComponent.a((ComponentContents)new LiteralContents.a(text)));
            this.armorStand.o(true);
            this.tracker = (PlayerChunkMap.EntityTracker)world.l().a.J.get(entity.getEntityId());
        }

        @Override
        public Hologram spawn(double offsetX, double offsetY, double offsetZ, double speed, long duration) {
            this.sendCreatePacket();
            this.sendMetaPacket();
            new Hologram.HologramRunnable(this, (Entity)this.entity, offsetX, offsetY, offsetZ, speed, duration).start();
            return this;
        }

        @Override
        public void sendCreatePacket() {
            PacketPlayOutSpawnEntity create = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)this.armorStand);
            this.sendPacketToTracked(create);
        }

        @Override
        public void sendMetaPacket() {
            List dataValues = this.armorStand.ap().b();
            if (dataValues == null) {
                return;
            }
            PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(this.armorStand.al(), dataValues);
            this.sendPacketToTracked(meta);
        }

        @Override
        public void sendTeleportPacket(Location loc) {
            this.armorStand.c(loc.getX(), loc.getY(), loc.getZ());
            PacketPlayOutEntityTeleport teleport = new PacketPlayOutEntityTeleport((net.minecraft.world.entity.Entity)this.armorStand);
            this.sendPacketToTracked(teleport);
        }

        @Override
        public void sendRemovePacket() {
            PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.al()});
            this.sendPacketToWorld(remove);
        }

        @Override
        public void sendPacketToTracked(Object packet) {
            if (this.tracker == null) {
                this.sendPacketToWorld(packet);
                return;
            }
            for (ServerPlayerConnection conn : this.tracker.f) {
                this.sendPacketIfToggled(conn.o().cz(), conn, packet);
            }
        }

        @Override
        public void sendPacketToWorld(Object packet) {
            for (Player player : this.entity.getWorld().getPlayers()) {
                this.sendPacketIfToggled(player.getUniqueId(), ((CraftPlayer)player).getHandle().c, packet);
            }
        }

        @Override
        public void sendPacket(Object connection, Object packet) {
            ((ServerPlayerConnection)connection).b((Packet)packet);
        }
    }
}

