/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.event;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.storage.StorageFileManager;
import com.zenya.damageindicator.util.DisplayBuilder;
import java.math.RoundingMode;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class HologramSpawnEvent
extends Event {
    private final LivingEntity ent;
    private final double amount;
    private final boolean isCrit;
    private static final HandlerList handlers = new HandlerList();

    public HologramSpawnEvent(LivingEntity ent, double amount, boolean isCrit) {
        this.ent = ent;
        this.amount = amount;
        this.isCrit = isCrit;
        this.fireEvent();
    }

    public void fireEvent() {
        double offsetY = StorageFileManager.getConfig().getDouble("hologram-offset") + this.ent.getEyeHeight();
        double speed = StorageFileManager.getConfig().getDouble("hologram-speed");
        int duration = StorageFileManager.getConfig().getInt("hologram-duration");
        String node = this.amount > 0.0 ? "heal-format" : (this.isCrit && StorageFileManager.getConfig().contains("crit-damage-format") ? "crit-damage-format" : "damage-format");
        String format = StorageFileManager.getConfig().getNearestValue(node, Math.abs(this.amount), RoundingMode.DOWN);
        String hologramText = new DisplayBuilder().withText(format).withValue(Math.abs(this.amount)).build();
        double offsetX = 0.0;
        double offsetZ = 0.0;
        if (StorageFileManager.getConfig().getBool("random-hologram-offset")) {
            offsetX = (Math.random() - 0.5) * 2.0;
            offsetZ = (Math.random() - 0.5) * 2.0;
        }
        DamageIndicator.PROTOCOL_NMS.getHologram(this.ent, this.ent.getLocation().add(offsetX, 0.0, offsetZ), hologramText).spawn(offsetX, offsetY, offsetZ, speed, duration);
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

