/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.file;

import com.zenya.damageindicator.DamageIndicator;
import com.zenya.damageindicator.file.StorageFile;
import com.zenya.damageindicator.storage.StorageFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.FileUtil;

public class YAMLFile
extends StorageFile {
    private final FileConfiguration origConfig;
    private FileConfiguration config;

    public YAMLFile(String fileName) {
        this(DamageIndicator.INSTANCE.getDataFolder().getPath(), fileName);
    }

    public YAMLFile(String directory, String fileName) {
        this(directory, fileName, null, false, null, null);
    }

    public YAMLFile(String directory, String fileName, Integer fileVersion, boolean resetFile, List<String> ignoredNodes, List<String> replaceNodes) {
        super(directory, fileName, fileVersion, resetFile);
        this.origConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(DamageIndicator.INSTANCE.getResource(fileName)));
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        if (fileVersion != null) {
            try {
                this.updateFile(ignoredNodes, replaceNodes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int getFileVersion() {
        return this.getInt("config-version");
    }

    private void updateFile(List<String> ignoredNodes, List<String> replaceNodes) throws IOException {
        if (!this.file.exists()) {
            DamageIndicator.INSTANCE.saveResource(this.fileName, false);
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        } else {
            if (this.getFileVersion() > this.fileVersion) {
                this.resetFile = true;
            }
            if (this.getFileVersion() != this.fileVersion.intValue()) {
                File oldConfigFile = new File(this.directory, this.fileName + ".v" + this.getFileVersion());
                FileUtil.copy((File)this.file, (File)oldConfigFile);
                this.file.delete();
                this.origConfig.save(this.file);
                YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldConfigFile);
                this.config = YamlConfiguration.loadConfiguration((File)this.file);
                if (!this.resetFile) {
                    for (String node : this.config.getKeys(true)) {
                        if (ignoredNodes != null && ignoredNodes.contains(node) || oldConfig.getKeys(true).contains(node + ".")) continue;
                        if (replaceNodes != null && replaceNodes.contains(node)) {
                            this.config.set(node, null);
                            this.config.createSection(node);
                        }
                        if (!oldConfig.contains(node)) continue;
                        this.config.set(node, oldConfig.get(node));
                    }
                    this.config.save(this.file);
                } else {
                    DamageIndicator.INSTANCE.saveResource(this.fileName, true);
                }
            }
        }
    }

    public boolean contains(String node) {
        return this.config.contains(node);
    }

    public String getString(String node) {
        return this.config.getString(node);
    }

    public int getInt(String node) {
        return this.config.getInt(node);
    }

    public double getDouble(String node) {
        return this.config.getDouble(node);
    }

    public boolean getBool(String node) {
        return this.config.getBoolean(node);
    }

    public List<String> getKeys(String node) {
        ArrayList<String> val;
        try {
            val = new ArrayList(this.config.getConfigurationSection(node).getKeys(false));
        }
        catch (Exception e) {
            e.printStackTrace();
            val = new ArrayList<String>();
        }
        return val;
    }

    public List<String> getList(String node) {
        return this.config.getStringList(node);
    }

    public boolean isList(String node) {
        return this.config.isList(node);
    }

    public boolean listContains(String node, String item) {
        List<String> list = this.getList(node);
        return !list.isEmpty() && list.contains(item);
    }

    public boolean isAllowed(String node, String string) {
        boolean isWhitelist = StorageFileManager.getConfig().getBool(node + "-as-whitelist");
        if (!StorageFileManager.getConfig().getBool(node + "-enabled")) {
            return true;
        }
        boolean result = StorageFileManager.getConfig().listContains(node, string);
        return isWhitelist == result;
    }

    public <T extends Number> String getNearestValue(String node, T reference, RoundingMode mode) {
        List<String> keyList = this.getKeys(node);
        if (keyList != null && keyList.size() != 0) {
            double smallestDiff = Math.abs(Double.parseDouble(keyList.get(0)) - reference.doubleValue());
            int smallestIndex = 0;
            block4: for (int i = 1; i < keyList.size(); ++i) {
                double difference = Math.abs(Double.parseDouble(keyList.get(i)) - reference.doubleValue());
                if (!(difference <= smallestDiff)) continue;
                switch (mode) {
                    case DOWN: {
                        if (!(Math.abs(reference.doubleValue()) >= Math.abs(Double.parseDouble(keyList.get(i))))) continue block4;
                        smallestDiff = difference;
                        smallestIndex = i;
                        continue block4;
                    }
                    case UP: {
                        if (!(Math.abs(reference.doubleValue()) <= Math.abs(Double.parseDouble(keyList.get(i))))) continue block4;
                        smallestDiff = difference;
                        smallestIndex = i;
                        continue block4;
                    }
                    default: {
                        smallestDiff = difference;
                        smallestIndex = i;
                    }
                }
            }
            return String.valueOf(this.getString(node + "." + keyList.get(smallestIndex)));
        }
        return "";
    }
}

