/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.spigotutils;

import com.google.common.base.Preconditions;
import com.zenya.damageindicator.libs.net.insprill.spigotutils.ServerEnvironment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftVersion {
    private static final Pattern versionPattern;
    public static final MinecraftVersion v1_8_0;
    public static final MinecraftVersion v1_8_1;
    public static final MinecraftVersion v1_8_2;
    public static final MinecraftVersion v1_8_3;
    public static final MinecraftVersion v1_8_4;
    public static final MinecraftVersion v1_8_5;
    public static final MinecraftVersion v1_8_6;
    public static final MinecraftVersion v1_8_7;
    public static final MinecraftVersion v1_8_8;
    public static final MinecraftVersion v1_9_0;
    public static final MinecraftVersion v1_9_1;
    public static final MinecraftVersion v1_9_2;
    public static final MinecraftVersion v1_9_3;
    public static final MinecraftVersion v1_9_4;
    public static final MinecraftVersion v1_10_0;
    public static final MinecraftVersion v1_10_1;
    public static final MinecraftVersion v1_10_2;
    public static final MinecraftVersion v1_11_0;
    public static final MinecraftVersion v1_11_1;
    public static final MinecraftVersion v1_11_2;
    public static final MinecraftVersion v1_12_0;
    public static final MinecraftVersion v1_12_1;
    public static final MinecraftVersion v1_12_2;
    public static final MinecraftVersion v1_13_0;
    public static final MinecraftVersion v1_13_1;
    public static final MinecraftVersion v1_13_2;
    public static final MinecraftVersion v1_14_0;
    public static final MinecraftVersion v1_14_1;
    public static final MinecraftVersion v1_14_2;
    public static final MinecraftVersion v1_14_3;
    public static final MinecraftVersion v1_14_4;
    public static final MinecraftVersion v1_15_0;
    public static final MinecraftVersion v1_15_1;
    public static final MinecraftVersion v1_15_2;
    public static final MinecraftVersion v1_16_0;
    public static final MinecraftVersion v1_16_1;
    public static final MinecraftVersion v1_16_2;
    public static final MinecraftVersion v1_16_3;
    public static final MinecraftVersion v1_16_4;
    public static final MinecraftVersion v1_16_5;
    public static final MinecraftVersion v1_17_0;
    public static final MinecraftVersion v1_17_1;
    public static final MinecraftVersion v1_18_0;
    public static final MinecraftVersion v1_18_1;
    public static final MinecraftVersion v1_18_2;
    public static final MinecraftVersion v1_19_0;
    public static final MinecraftVersion v1_19_1;
    public static final MinecraftVersion v1_19_2;
    public static final MinecraftVersion v1_19_3;
    public static final MinecraftVersion v1_19_4;
    public static final MinecraftVersion v1_20_0;
    public static final MinecraftVersion v1_20_1;
    public static final MinecraftVersion v1_20_2;
    public static final MinecraftVersion v1_20_3;
    public static final MinecraftVersion v1_20_4;
    public static final MinecraftVersion v1_20_5;
    public static final MinecraftVersion v1_20_6;
    public static final MinecraftVersion v1_21_0;
    public static final MinecraftVersion v1_21_1;
    public static final MinecraftVersion v1_21_2;
    public static final MinecraftVersion v1_21_3;
    public static final MinecraftVersion v1_21_4;
    public static final MinecraftVersion v1_22_0;
    @NotNull
    private static final MinecraftVersion currentVersion;
    private final int major;
    private final int patch;

    @NotNull
    public static MinecraftVersion getCurrentVersion() {
        return currentVersion;
    }

    public MinecraftVersion(int major, int patch) {
        this.major = major;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getPatch() {
        return this.patch;
    }

    @NotNull
    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    @NotNull
    public String getDisplayName(boolean includeEmptyPatch) {
        return "1." + this.major + (this.patch == 0 && !includeEmptyPatch ? "" : "." + this.patch);
    }

    public static boolean isNew() {
        return currentVersion.getMajor() >= 13;
    }

    public static boolean is(@NotNull MinecraftVersion version) {
        MinecraftVersion.checkNotNull(version);
        return currentVersion.getMajor() == version.getMajor() && currentVersion.getPatch() == version.getPatch();
    }

    public static boolean isMajor(@NotNull MinecraftVersion version) {
        MinecraftVersion.checkNotNull(version);
        return currentVersion.getMajor() == version.getMajor();
    }

    public static boolean isNewerThan(@NotNull MinecraftVersion version) {
        MinecraftVersion.checkNotNull(version);
        return currentVersion.getMajor() > version.getMajor() || currentVersion.getMajor() == version.getMajor() && currentVersion.getPatch() > version.getPatch();
    }

    public static boolean isAtLeast(@NotNull MinecraftVersion version) {
        MinecraftVersion.checkNotNull(version);
        return currentVersion.getMajor() > version.getMajor() || currentVersion.getMajor() == version.getMajor() && currentVersion.getPatch() >= version.getPatch();
    }

    public static boolean isOlderThan(@NotNull MinecraftVersion version) {
        MinecraftVersion.checkNotNull(version);
        return currentVersion.getMajor() < version.getMajor() || currentVersion.getMajor() == version.getMajor() && currentVersion.getPatch() < version.getPatch();
    }

    @Deprecated
    @Nullable
    public static String getCraftBukkitVersion() {
        String[] pckg = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        return pckg.length >= 4 ? pckg[3] : null;
    }

    private static int parseIntSafe(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private static void checkNotNull(@Nullable MinecraftVersion version) {
        Preconditions.checkNotNull((Object)version, (Object)"Version cannot be null");
    }

    public boolean equals(Object o) {
        if (!(o instanceof MinecraftVersion)) {
            return false;
        }
        MinecraftVersion other = (MinecraftVersion)o;
        return this.major == other.major && this.patch == other.patch;
    }

    public int hashCode() {
        int result = 31;
        result = 31 * result + this.major;
        result = 31 * result + this.patch;
        return result;
    }

    public String toString() {
        return "MinecraftVersion(major=" + this.getMajor() + ", patch=" + this.getPatch() + ")";
    }

    static {
        String[] version;
        Matcher matcher;
        versionPattern = Pattern.compile("(?i)(?<major>\\d)\\.(?<minor>\\d+)\\.?(?<patch>\\d+)?");
        v1_8_0 = new MinecraftVersion(8, 0);
        v1_8_1 = new MinecraftVersion(8, 1);
        v1_8_2 = new MinecraftVersion(8, 2);
        v1_8_3 = new MinecraftVersion(8, 3);
        v1_8_4 = new MinecraftVersion(8, 4);
        v1_8_5 = new MinecraftVersion(8, 5);
        v1_8_6 = new MinecraftVersion(8, 6);
        v1_8_7 = new MinecraftVersion(8, 7);
        v1_8_8 = new MinecraftVersion(8, 8);
        v1_9_0 = new MinecraftVersion(9, 0);
        v1_9_1 = new MinecraftVersion(9, 1);
        v1_9_2 = new MinecraftVersion(9, 2);
        v1_9_3 = new MinecraftVersion(9, 3);
        v1_9_4 = new MinecraftVersion(9, 4);
        v1_10_0 = new MinecraftVersion(10, 0);
        v1_10_1 = new MinecraftVersion(10, 1);
        v1_10_2 = new MinecraftVersion(10, 2);
        v1_11_0 = new MinecraftVersion(11, 0);
        v1_11_1 = new MinecraftVersion(11, 1);
        v1_11_2 = new MinecraftVersion(11, 2);
        v1_12_0 = new MinecraftVersion(12, 0);
        v1_12_1 = new MinecraftVersion(12, 1);
        v1_12_2 = new MinecraftVersion(12, 2);
        v1_13_0 = new MinecraftVersion(13, 0);
        v1_13_1 = new MinecraftVersion(13, 1);
        v1_13_2 = new MinecraftVersion(13, 2);
        v1_14_0 = new MinecraftVersion(14, 0);
        v1_14_1 = new MinecraftVersion(14, 1);
        v1_14_2 = new MinecraftVersion(14, 2);
        v1_14_3 = new MinecraftVersion(14, 3);
        v1_14_4 = new MinecraftVersion(14, 4);
        v1_15_0 = new MinecraftVersion(15, 0);
        v1_15_1 = new MinecraftVersion(15, 1);
        v1_15_2 = new MinecraftVersion(15, 2);
        v1_16_0 = new MinecraftVersion(16, 0);
        v1_16_1 = new MinecraftVersion(16, 1);
        v1_16_2 = new MinecraftVersion(16, 2);
        v1_16_3 = new MinecraftVersion(16, 3);
        v1_16_4 = new MinecraftVersion(16, 4);
        v1_16_5 = new MinecraftVersion(16, 5);
        v1_17_0 = new MinecraftVersion(17, 0);
        v1_17_1 = new MinecraftVersion(17, 1);
        v1_18_0 = new MinecraftVersion(18, 0);
        v1_18_1 = new MinecraftVersion(18, 1);
        v1_18_2 = new MinecraftVersion(18, 2);
        v1_19_0 = new MinecraftVersion(19, 0);
        v1_19_1 = new MinecraftVersion(19, 1);
        v1_19_2 = new MinecraftVersion(19, 2);
        v1_19_3 = new MinecraftVersion(19, 3);
        v1_19_4 = new MinecraftVersion(19, 4);
        v1_20_0 = new MinecraftVersion(20, 0);
        v1_20_1 = new MinecraftVersion(20, 1);
        v1_20_2 = new MinecraftVersion(20, 2);
        v1_20_3 = new MinecraftVersion(20, 3);
        v1_20_4 = new MinecraftVersion(20, 4);
        v1_20_5 = new MinecraftVersion(20, 5);
        v1_20_6 = new MinecraftVersion(20, 6);
        v1_21_0 = new MinecraftVersion(21, 0);
        v1_21_1 = new MinecraftVersion(21, 1);
        v1_21_2 = new MinecraftVersion(21, 2);
        v1_21_3 = new MinecraftVersion(21, 3);
        v1_21_4 = new MinecraftVersion(21, 4);
        v1_22_0 = new MinecraftVersion(22, 0);
        int major = 0;
        int patch = 0;
        String versionStr = Bukkit.getVersion();
        if (ServerEnvironment.isPaper()) {
            try {
                versionStr = (String)Bukkit.getServer().getClass().getMethod("getMinecraftVersion", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((matcher = versionPattern.matcher(versionStr)).find()) {
            if (matcher.groupCount() >= 2) {
                major = MinecraftVersion.parseIntSafe(matcher.group("minor"));
            }
            if (matcher.groupCount() >= 3) {
                patch = MinecraftVersion.parseIntSafe(matcher.group("patch"));
            }
        }
        if (major == 0 && MinecraftVersion.getCraftBukkitVersion() != null && (version = MinecraftVersion.getCraftBukkitVersion().split("_")).length >= 2) {
            major = MinecraftVersion.parseIntSafe(version[1]);
        }
        currentVersion = new MinecraftVersion(major, patch);
    }
}

