/*
 * Decompiled with CFR 0.152.
 */
package com.zenya.damageindicator.libs.net.insprill.spigotutils;

import com.google.common.base.Preconditions;

public enum ServerEnvironment {
    PURPUR("org.purpurmc.purpur.PurpurConfig"),
    FOLIA("io.papermc.paper.threadedregions.scheduler.FoliaRegionScheduler", "ca.spottedleaf.moonrise.common.util.TickThread"),
    MOCK_BUKKIT("be.seeseemelk.mockbukkit.ServerMock", "org.mockbukkit.mockbukkit.ServerMock"),
    PAPER("com.destroystokyo.paper.PaperConfig", "io.papermc.paper.ServerBuildInfo"),
    SPIGOT("org.spigotmc.SpigotConfig", "org.bukkit.Server.Spigot"),
    BUKKIT("org.bukkit.Bukkit");

    private boolean isCurrentEnvironment;

    private ServerEnvironment(String ... checkClasses) {
        Preconditions.checkNotNull((Object)checkClasses, (Object)"Check classes cannot be null");
        for (String checkClass : checkClasses) {
            try {
                Class.forName(checkClass);
                this.isCurrentEnvironment = true;
                break;
            }
            catch (ClassNotFoundException e) {
                this.isCurrentEnvironment = false;
            }
        }
    }

    public static boolean isPurpur() {
        return ServerEnvironment.PURPUR.isCurrentEnvironment;
    }

    public static boolean isMockBukkit() {
        return ServerEnvironment.MOCK_BUKKIT.isCurrentEnvironment;
    }

    public static boolean isFolia() {
        return ServerEnvironment.FOLIA.isCurrentEnvironment;
    }

    public static boolean isPaper() {
        return ServerEnvironment.PAPER.isCurrentEnvironment;
    }

    public static boolean isSpigot() {
        return ServerEnvironment.SPIGOT.isCurrentEnvironment;
    }

    public static boolean isBukkit() {
        return ServerEnvironment.BUKKIT.isCurrentEnvironment;
    }
}

